/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.grpc.controllers;

import io.grpc.stub.StreamObserver;
import java.util.List;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ErrorDescriptionFactory;
import org.pipservices4.commons.errors.InvocationException;
import org.pipservices4.components.context.Context;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.grpc.commandable.CommandableGrpc;
import org.pipservices4.grpc.commandable.ErrorDescription;
import org.pipservices4.grpc.commandable.InvokeReply;
import org.pipservices4.grpc.commandable.InvokeRequest;
import org.pipservices4.grpc.controllers.CommandFunction;
import org.pipservices4.grpc.controllers.GrpcController;
import org.pipservices4.rpc.commands.CommandSet;
import org.pipservices4.rpc.commands.ICommand;
import org.pipservices4.rpc.commands.ICommandable;
import org.pipservices4.rpc.trace.InstrumentTiming;

public abstract class CommandableGrpcController
extends GrpcController {
    private final String _name;

    public CommandableGrpcController(String name) {
        super(CommandableGrpc.getServiceDescriptor());
        this._name = name != null ? name : CommandableGrpc.getServiceDescriptor().getName();
        this._dependencyResolver.put("controller", (Object)"none");
    }

    protected void registerCommadableMethod(String method, CommandFunction action) {
        this._commandableMethods.put(method, action);
    }

    private void invokeCommand(InvokeRequest request, StreamObserver<InvokeReply> responseObserver) {
        String method = request.getMethod();
        String traceId = request.getTraceId();
        CommandFunction action = (CommandFunction)this._commandableMethods.get(method);
        if (action == null) {
            ApplicationException err = new InvocationException(traceId, "METHOD_NOT_FOUND", "Method " + method + " was not found").withDetails("method", (Object)method);
            responseObserver.onNext((Object)InvokeReply.newBuilder().setError(this.createErrorResponse((Exception)err)).build());
            responseObserver.onCompleted();
            this.createErrorResponse((Exception)err);
            return;
        }
        try {
            boolean argsEmpty = request.getArgsEmpty();
            String argsJson = request.getArgsJson();
            Parameters args = !argsEmpty && !argsJson.isEmpty() ? Parameters.fromJson((String)argsJson) : new Parameters();
            Object result = action.apply((IContext)Context.fromTraceId((String)traceId), args);
            InvokeReply.Builder response = InvokeReply.newBuilder().setResultEmpty(result == null);
            if (result != null) {
                response.setResultJson(JsonConverter.toJson((Object)result));
            }
            if (result instanceof Exception) {
                response.setError(this.createErrorResponse((Exception)result));
            }
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        }
        catch (Exception ex) {
            ApplicationException err = new InvocationException(traceId, "METHOD_FAILED", "Method " + method + " failed").wrap((Throwable)ex).withDetails("method", (Object)method);
            responseObserver.onNext((Object)InvokeReply.newBuilder().setError(this.createErrorResponse((Exception)err)).build());
            responseObserver.onCompleted();
            this.createErrorResponse((Exception)err);
        }
    }

    private ErrorDescription createErrorResponse(Exception ex) {
        org.pipservices4.commons.errors.ErrorDescription errDescr = ErrorDescriptionFactory.create((Exception)ex);
        ErrorDescription.Builder protoErr = ErrorDescription.newBuilder().setStatus(errDescr.getStatus());
        if (errDescr.getCause() != null) {
            protoErr.setCause(errDescr.getCause());
        }
        if (errDescr.getTraceId() != null) {
            protoErr.setTraceId(errDescr.getTraceId());
        }
        if (errDescr.getMessage() != null) {
            protoErr.setMessage(errDescr.getMessage());
        }
        if (errDescr.getCause() != null) {
            protoErr.setCause(errDescr.getCause());
        }
        if (errDescr.getStackTrace() != null) {
            protoErr.setStackTrace(errDescr.getStackTrace());
        }
        if (errDescr.getCategory() != null) {
            protoErr.setCategory(errDescr.getCategory());
        }
        if (errDescr.getCode() != null) {
            protoErr.setCode(errDescr.getCode());
        }
        return protoErr.build();
    }

    @Override
    public void register() {
        ICommandable service = null;
        try {
            service = (ICommandable)this._dependencyResolver.getOneRequired(ICommandable.class, "service");
        }
        catch (ReferenceException e) {
            throw new RuntimeException(e);
        }
        CommandSet _commandSet = service.getCommandSet();
        List commands = _commandSet.getCommands();
        this.registerMethod("invoke", null, this::invokeCommand);
        for (ICommand command : commands) {
            String method = this._name + "." + command.getName();
            this.registerCommadableMethod(method, (context, args) -> {
                InstrumentTiming timing = this.instrument(context, method);
                try {
                    Object object = command.execute(context, (Parameters)args);
                    return object;
                }
                catch (Exception ex) {
                    timing.endFailure(ex);
                    Exception exception = ex;
                    return exception;
                }
                finally {
                    timing.endTiming();
                }
            });
        }
    }
}

