/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.rpc.commands;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.InvocationException;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.exec.IExecutable;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.rpc.commands.ICommand;

public class Command
implements ICommand {
    private final String _name;
    private final Schema _schema;
    private final IExecutable _function;

    public Command(String name, Schema schema, IExecutable function) {
        if (name == null) {
            throw new NullPointerException("Command name is not set");
        }
        if (function == null) {
            throw new NullPointerException("Command function is not set");
        }
        this._name = name;
        this._schema = schema;
        this._function = function;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public Object execute(IContext context, Parameters args) throws ApplicationException {
        if (this._schema != null) {
            this._schema.validateAndThrowException(context != null ? ContextResolver.getTraceId((IContext)context) : null, (Object)args);
        }
        try {
            return this._function.execute(context, args);
        }
        catch (Throwable ex) {
            throw new InvocationException(context != null ? ContextResolver.getTraceId((IContext)context) : null, "EXEC_FAILED", "Execution " + this._name + " failed: " + String.valueOf(ex)).withDetails("command", (Object)this._name).wrap(ex);
        }
    }

    @Override
    public List<ValidationResult> validate(Parameters args) {
        if (this._schema != null) {
            return this._schema.validate((Object)args);
        }
        return new ArrayList<ValidationResult>();
    }
}

