/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.rpc.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.BadRequestException;
import org.pipservices4.components.context.Context;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.data.keys.IdGenerator;
import org.pipservices4.data.validate.ValidationException;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;
import org.pipservices4.rpc.commands.ICommand;
import org.pipservices4.rpc.commands.ICommandInterceptor;
import org.pipservices4.rpc.commands.IEvent;
import org.pipservices4.rpc.commands.IEventListener;
import org.pipservices4.rpc.commands.InterceptedCommand;

public class CommandSet {
    private final List<ICommand> _commands = new ArrayList<ICommand>();
    private final List<IEvent> _events = new ArrayList<IEvent>();
    private final List<ICommandInterceptor> _interceptors = new ArrayList<ICommandInterceptor>();
    private final Map<String, ICommand> _commandsByName = new HashMap<String, ICommand>();
    private final Map<String, IEvent> _eventsByName = new HashMap<String, IEvent>();

    public List<ICommand> getCommands() {
        return this._commands;
    }

    public List<IEvent> getEvents() {
        return this._events;
    }

    public ICommand findCommand(String commandName) {
        return this._commandsByName.get(commandName);
    }

    public IEvent findEvent(String eventName) {
        return this._eventsByName.get(eventName);
    }

    private void buildCommandChain(ICommand command) {
        ICommand next = command;
        for (int i = this._interceptors.size() - 1; i >= 0; --i) {
            next = new InterceptedCommand(this._interceptors.get(i), next);
        }
        this._commandsByName.put(next.getName(), next);
    }

    private void rebuildAllCommandChains() {
        this._commandsByName.clear();
        for (ICommand command : this._commands) {
            this.buildCommandChain(command);
        }
    }

    public void addCommand(ICommand command) {
        this._commands.add(command);
        this.buildCommandChain(command);
    }

    public void addCommands(List<ICommand> commands) {
        for (ICommand command : commands) {
            this.addCommand(command);
        }
    }

    public void addEvent(IEvent event) {
        this._events.add(event);
        this._eventsByName.put(event.getName(), event);
    }

    public void addEvents(List<IEvent> events) {
        for (IEvent event : events) {
            this.addEvent(event);
        }
    }

    public void addCommandSet(CommandSet commandSet) {
        for (ICommand command : commandSet.getCommands()) {
            this.addCommand(command);
        }
        for (IEvent event : commandSet.getEvents()) {
            this.addEvent(event);
        }
    }

    public void addListener(IEventListener listener) {
        for (IEvent event : this._events) {
            event.addListener(listener);
        }
    }

    public void removeListener(IEventListener listener) {
        for (IEvent event : this._events) {
            event.removeListener(listener);
        }
    }

    public void addInterceptor(ICommandInterceptor interceptor) {
        this._interceptors.add(interceptor);
        this.rebuildAllCommandChains();
    }

    public Object execute(IContext context, String commandName, Parameters args) throws ApplicationException {
        String traceId;
        ICommand cref = this.findCommand(commandName);
        String string = traceId = context != null ? ContextResolver.getTraceId((IContext)context) : null;
        if (cref == null) {
            throw new BadRequestException(traceId, "CMD_NOT_FOUND", "Requested command does not exist").withDetails("command", (Object)commandName);
        }
        if (traceId == null) {
            traceId = IdGenerator.nextShort();
        }
        List<ValidationResult> results = cref.validate(args);
        ValidationException.throwExceptionIfNeeded((String)traceId, results, (boolean)false);
        return cref.execute((IContext)(context != null ? context : Context.fromTraceId((String)traceId)), args);
    }

    public List<ValidationResult> validate(String commandName, Parameters args) {
        ICommand cref = this.findCommand(commandName);
        if (cref == null) {
            ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
            results.add(new ValidationResult(null, ValidationResultType.Error, "CMD_NOT_FOUND", "Requested command does not exist", null, null));
            return results;
        }
        return cref.validate(args);
    }

    public void notify(IContext context, String eventName, Parameters args) throws ApplicationException {
        IEvent e = this.findEvent(eventName);
        if (e != null) {
            e.notify(context, args);
        }
    }
}

