package com.service.basic.controllers.version1;

import com.service.basic.data.version1.RequestV1;
import com.service.basic.data.version1.ResponseV1;
import com.service.basic.logic.IBasicService;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.context.Context;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.grpc.controllers.GrpcController;
/**
 * Controller that receives remove calls via GRPC protocol.
 */
public class BasicGrpcControllerV1 extends GrpcController {
    private IBasicService _service;
	
    /**
     * Creates an instance of this service.
     */
    public BasicGrpcControllerV1() {
        super(com.service.basic.protos.BasicControllerGrpc.getServiceDescriptor());
        this._dependencyResolver.put("service", new Descriptor("service-basic", "service", "default", "*", "*"));
    }

    /**
     * Sets references to dependent components.
     *
     * @param references 	references to locate the component dependencies.
     */
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        super.setReferences(references);
        this._service = this._dependencyResolver.getOneRequired(IBasicService.class, "service");
    }

    /**
     * Service command method that define the operation.
     * 
     * @param request gRPC request call object.
     * @param responseObserver gRPC response object.
     * @return response object defined in proto file.
     */
    public void doSomething(com.service.basic.protos.Query request,
                           io.grpc.stub.StreamObserver<com.service.basic.protos.ResponseV1> responseObserver) {

        var result = this._service.doSomething(
                Context.fromTraceId(request.getTraceId()),
                new RequestV1(request.getRequest().getValue())
        );

        responseObserver.onNext(this.responseToObject(result));
        responseObserver.onCompleted();
    }

    private com.service.basic.protos.ResponseV1 responseToObject(ResponseV1 response) {
        if (response == null)
            return com.service.basic.protos.ResponseV1.getDefaultInstance();

        return com.service.basic.protos.ResponseV1.newBuilder()
                .setValue(response.getValue()).build();
    }
    
    /**
     * Registers all service routes in Google Function.
     */
    @Override
    public void register() {
        this.registerMethod(
            "do_something", 
            null,
            this::doSomething
        );
    }
}
