package com.service.basic.controllers.version1;

import com.service.basic.data.version1.RequestV1;
import com.service.basic.data.version1.ResponseV1;
import com.service.basic.logic.BasicService;
import org.junit.*;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.InvalidStateException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.References;
import org.pipservices4.grpc.test.TestCommandableGrpcClient;

import java.io.IOException;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

public class BasicCommandableGrpcControllerV1Test {
    RequestV1 _request;

    static ConfigParams grpcConfig = ConfigParams.fromTuples(
            "connection.protocol", "http",
            "connection.host", "localhost",
            "connection.port", 3001
    );

    static BasicCommandableGrpcControllerV1 controller;

    static TestCommandableGrpcClient client;

    @BeforeClass
    public static void setupClass() throws ApplicationException {
        var service = new BasicService();
        controller = new BasicCommandableGrpcControllerV1();
        controller.configure(grpcConfig);

        client = new TestCommandableGrpcClient("basic_v1.BasicController");
        client.configure(grpcConfig);

        References references = References.fromTuples(
                new Descriptor("service-basic", "service", "default", "default", "1.0"), service,
                new Descriptor("service-basic", "controller", "grpc", "default", "1.0"), controller
        );
        service.setReferences(references);
        controller.setReferences(references);

        controller.open(null);
        client.open(null);
    }

    @AfterClass
    public static void teardownClass() throws ApplicationException {
        client.close(null);
        controller.close(null);
    }

    @Test
    public void testOperations() throws IOException {
        _request = new RequestV1("test_value");
        var response = client.callCommand(ResponseV1.class, "do_something", null, Parameters.fromTuples("request", _request));

        assertNotNull(response);
        assertEquals(_request.getValue(), response.getValue());
    }
}
