package com.service.basic.controllers.version1;

import com.service.basic.data.version1.RequestV1;
import com.service.basic.data.version1.ResponseV1;
import com.service.basic.logic.BasicService;
import org.junit.*;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.InvalidStateException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.References;
import org.pipservices4.http.test.TestCommandableHttpClient;

import java.io.IOException;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

public class BasicCommandableHttpControllerV1Test {
    RequestV1 _request;

    static ConfigParams httpConfig = ConfigParams.fromTuples(
            "connection.protocol", "http",
            "connection.host", "localhost",
            "connection.port", 3001
    );

    static BasicCommandableHttpControllerV1 controller;

    static TestCommandableHttpClient client;

    @BeforeClass
    public static void setupClass() throws ApplicationException {
        var service = new BasicService();
        controller = new BasicCommandableHttpControllerV1();
        controller.configure(httpConfig);

        client = new TestCommandableHttpClient("commandable_basic/v1");
        client.configure(httpConfig);

        References references = References.fromTuples(
                new Descriptor("service-basic", "service", "default", "default", "1.0"), service,
                new Descriptor("service-basic", "controller", "http", "default", "1.0"), controller
        );
        service.setReferences(references);
        controller.setReferences(references);

        controller.open(null);
        client.open(null);
    }

    @AfterClass
    public static void teardownClass() throws ApplicationException {
        client.close(null);
        controller.close(null);        
    }

    @Test
    public void testOperations() throws IOException, ApplicationException {
        _request = new RequestV1("test_value");
        var response = client.callCommand(ResponseV1.class, "do_something", null,
                Parameters.fromTuples("request", _request));

        assertNotNull(response);
        assertEquals(_request.getValue(), response.getValue());
    }
}
