package com.service.basic.controllers.version1;

import com.service.basic.data.version1.RequestV1;
import com.service.basic.data.version1.ResponseV1;
import com.service.basic.logic.BasicService;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.junit.*;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.References;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

public class BasicRestControllerV1Test {
    static ConfigParams restConfig = ConfigParams.fromTuples(
            "connection.protocol", "http",
            "connection.host", "localhost",
            "connection.port", 3000
    );

    RequestV1 _request;

    Client rest;
    static BasicRestControllerV1 controller;

    @BeforeClass
    public static void setupAll() throws ApplicationException {
        var service = new BasicService();

        controller = new BasicRestControllerV1();
        controller.configure(restConfig);

        var references = References.fromTuples(
                new Descriptor("service-basic", "service", "default", "default", "1.0"), service,
                new Descriptor("service-basic", "controller", "rest-http", "default", "1.0"), controller
        );
        controller.setReferences(references);

        controller.open(null);
    }

    @Before
    public void setup() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(new JacksonFeature());
        rest = ClientBuilder.newClient(clientConfig);

        _request = new RequestV1("test_value");
    }

    @AfterClass
    public static void teardown() throws ApplicationException {
        controller.close(null);
    }

    @Test
    public void testOperations() {
        ResponseV1 res = invoke(ResponseV1.class, HttpMethod.POST, "/basic/v1/do_something", _request);

        assertNotNull(res);
        assertEquals(res.getValue(), _request.getValue());
    }

    private <T> T invoke(Class<T> type, String method, String route, Object entity) {
        try (Response response = rest.target("http://localhost:3000" + route)
                .request(MediaType.APPLICATION_JSON).headers(new MultivaluedHashMap<>())
                .method(method, Entity.entity(entity, MediaType.APPLICATION_JSON))) {
            return response.readEntity(type);
        }
    }
}
