package com.service.basic.build;

import com.service.basic.controllers.version1.BasicCommandableGrpcControllerV1;
import com.service.basic.controllers.version1.BasicCommandableHttpControllerV1;
import com.service.basic.controllers.version1.BasicGrpcControllerV1;
import com.service.basic.controllers.version1.BasicRestControllerV1;
import com.service.basic.logic.BasicService;
import org.pipservices4.components.build.Factory;
import org.pipservices4.components.refer.Descriptor;

/**
 * Creates Basic Service components by their descriptors.
 */
public class BasicServiceFactory extends Factory {
    private static final Descriptor ServiceDescriptor = new Descriptor("service-basic", "service", "default", "*", "1.0");
    private static final Descriptor CommandableHttpControllerV1Descriptor = new Descriptor("service-basic", "controller", "commandable-http", "*", "1.0");
    private static final Descriptor CommandableGrpcControllerV1Descriptor = new Descriptor("service-basic", "controller", "commandable-grpc", "*", "1.0");
    private static final Descriptor RestControllerV1Descriptor = new Descriptor("service-basic", "controller", "rest-http", "*", "1.0");
    private static final Descriptor GrpcControllerV1Descriptor = new Descriptor("service-basic", "controller", "grpc", "*", "1.0");

    public BasicServiceFactory() {
        super();
        registerAsType(BasicServiceFactory.ServiceDescriptor, BasicService.class);
        registerAsType(BasicServiceFactory.CommandableHttpControllerV1Descriptor, BasicCommandableHttpControllerV1.class);
        registerAsType(BasicServiceFactory.CommandableGrpcControllerV1Descriptor, BasicCommandableGrpcControllerV1.class);
        registerAsType(BasicServiceFactory.RestControllerV1Descriptor, BasicRestControllerV1.class);
        registerAsType(BasicServiceFactory.GrpcControllerV1Descriptor, BasicGrpcControllerV1.class);
    }
}
