/*
 * Decompiled with CFR 0.152.
 */
package com.service.basic.controllers.version1;

import com.service.basic.data.version1.RequestV1;
import com.service.basic.data.version1.RequestV1Schema;
import com.service.basic.data.version1.ResponseV1;
import com.service.basic.logic.IBasicService;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.context.Context;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.ObjectSchema;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.http.controllers.RestController;
import org.pipservices4.rpc.trace.InstrumentTiming;

public class BasicRestControllerV1
extends RestController {
    private IBasicService _service;

    public BasicRestControllerV1() {
        this._baseRoute = "basic/v1";
        this._dependencyResolver.put("service", (Object)new Descriptor("service-basic", "service", "default", "*", "*"));
    }

    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        super.setReferences(references);
        this._service = (IBasicService)this._dependencyResolver.getOneRequired(IBasicService.class, "service");
    }

    private Response doSomething(ContainerRequestContext req) {
        Context context = Context.fromTraceId((String)this.getTraceId(req));
        InstrumentTiming timing = this.instrument((IContext)context, "basic.v1.do_something");
        try {
            ResponseV1 res = this._service.doSomething((IContext)context, (RequestV1)JsonConverter.fromJson(RequestV1.class, (String)new String(req.getEntityStream().readAllBytes(), StandardCharsets.UTF_8)));
            timing.endSuccess();
            return this.sendResult(res);
        }
        catch (IOException err) {
            timing.endFailure((Exception)err);
            return this.sendError(err);
        }
    }

    public void register() {
        this.registerRoute("POST", "/do_something", (Schema)new ObjectSchema().withRequiredProperty("body", (Object)new RequestV1Schema(), new IValidationRule[0]), this::doSomething);
        this.registerOpenApiSpecFromFile("./src/com/service/basic/swagger/requests_v1.yaml");
    }
}

