package com.service.basic.containers;

import com.service.basic.build.BasicServiceFactory;
import org.pipservices4.container.containers.ProcessContainer;
import org.pipservices4.elasticsearch.build.DefaultElasticSearchFactory;
import org.pipservices4.grpc.build.DefaultGrpcFactory;
import org.pipservices4.http.build.DefaultHttpFactory;
import org.pipservices4.prometheus.build.DefaultPrometheusFactory;
import org.pipservices4.swagger.build.DefaultSwaggerFactory;

/**
 * Inversion of control (IoC) container that creates components and manages their lifecycle.
 * That container runs as a system process.
 * It processes command line arguments and handles unhandled exceptions and Ctrl-C signal
 * to gracefully shutdown the container.
 */
public class BasicProcess extends ProcessContainer {
        /**
     * Creates an instance of this container.
     */
    public BasicProcess(){
        super("service-basic", "Basic data microservice");

        this._configPath = "./config/config.yml";

        this._factories.add(new BasicServiceFactory());
        this._factories.add(new DefaultElasticSearchFactory());
        this._factories.add(new DefaultPrometheusFactory());
        this._factories.add(new DefaultHttpFactory());
        this._factories.add(new DefaultSwaggerFactory());
        this._factories.add(new DefaultGrpcFactory());
    }
}
