package com.service.basic.controllers.version1;

import com.service.basic.data.version1.RequestV1;
import com.service.basic.logic.BasicService;
import com.service.basic.protos.BasicControllerGrpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.junit.*;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.InvalidStateException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.References;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

public class BasicGrpcControllerV1Test {
    RequestV1 _request;

    static ConfigParams grpcConfig = ConfigParams.fromTuples(
            "connection.protocol", "http",
            "connection.host", "localhost",
            "connection.port", 3000
    );

    static BasicGrpcControllerV1 controller;

    ManagedChannel _channel;
    BasicControllerGrpc.BasicControllerBlockingStub client;

    @BeforeClass
    public static void setupClass() throws ApplicationException {
        var service = new BasicService();
        controller = new BasicGrpcControllerV1();
        controller.configure(grpcConfig);


        References references = References.fromTuples(
                new Descriptor("service-basic", "service", "default", "default", "1.0"), service,
                new Descriptor("service-basic", "controller", "grpc", "default", "1.0"), controller
        );
        service.setReferences(references);
        controller.setReferences(references);

        controller.open(null);
    }

    @AfterClass
    public static void teardownClass() throws InvalidStateException {
        controller.close(null);        
    }

    @Before
    public void setup() {
        _channel = ManagedChannelBuilder.forTarget("localhost:3000")
                // Channels are secure by default (via SSL/TLS). For the example we disable TLS to avoid
                // needing certificates.
                .usePlaintext()
                .build();
        client = BasicControllerGrpc.newBlockingStub(_channel);

        _request = new RequestV1("test_value");
    }

    @After
    public void teardown() throws InterruptedException {
        _channel.shutdownNow().awaitTermination(5, TimeUnit.SECONDS);
    }

    @Test
    public void testOperations() throws IOException {
        var req = com.service.basic.protos.Query.newBuilder()
                .setRequest(com.service.basic.protos.RequestV1.newBuilder().setValue(_request.getValue()).build())
                .build();

        var response = client.doSomething(req);

        assertNotNull(response);
        assertEquals(response.getValue(), _request.getValue());
    }
}
