package com.service.basic.logic;

import com.service.basic.data.version1.RequestV1;
import com.service.basic.data.version1.ResponseV1;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.References;

import static org.junit.Assert.*;

public class BasicServiceTest {
    static String response = System.getenv("DEFAULT_RESPONSE") != null ? System.getenv("DEFAULT_RESPONSE") : "Received";
    static BasicService service;


    @BeforeClass
    public static void setupAll() throws ApplicationException {
        service = new BasicService();

        service.configure(ConfigParams.fromTuples(
            "configuration.response", response
        ));

        var references = References.fromTuples(
            new Descriptor("service-basic", "service", "default", "default", "1.0"), service
        );
        service.setReferences(references);
    }

    @Test
    public void testOperations() {
        // Happy path
        RequestV1 req = new RequestV1("test_value");
        ResponseV1 res = service.doSomething(null, req);
        assertNotNull(res);
        assertEquals(req.getValue(), res.getValue());

        // Boundary
        req.setValue("");
        res = service.doSomething(null, req);
        assertEquals("Received", res.getValue());

        // Negative
        assertThrows(NullPointerException.class, () -> service.doSomething(null, null));
    }
}
