package com.service.basic.logic;

import com.service.basic.data.version1.RequestV1;
import com.service.basic.data.version1.RequestV1Schema;
import org.pipservices4.commons.data.AnyValueMap;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.data.validate.ObjectSchema;
import org.pipservices4.rpc.commands.Command;
import org.pipservices4.rpc.commands.CommandSet;
import org.pipservices4.rpc.commands.ICommand;

/**
 * Contains a set of commands and events supported by a ICommandable object.
 * The BasicCommandSet supports command interceptors to extend and the command call chain.
 */
public class BasicCommandSet extends CommandSet {
    private final IBasicService _service;

    public BasicCommandSet(IBasicService service) {
        super();
        _service = service;

        addCommand(makeDoSomething());
    }

        /**
     * Creates new command event with name and parameters.
     * @return ICommand object that can be registered as new service command.
     */
    private ICommand makeDoSomething() {
        return new Command(
            "do_something",
            new ObjectSchema()
                .withOptionalProperty("request", new RequestV1Schema()),
            (context, args) -> {
                RequestV1 req = extractRequest(args);
                return _service.doSomething(context, req);
            }
        );
    }

    
    private static RequestV1 extractRequest(Parameters args) {
        AnyValueMap map = args.getAsMap("request");
        String value = map.getAsNullableString("value");

        return new RequestV1(value);
    }
}
