/*
 * Decompiled with CFR 0.152.
 */
package com.service.basic.logic;

import com.service.basic.data.version1.RequestV1;
import com.service.basic.data.version1.ResponseV1;
import com.service.basic.logic.BasicCommandSet;
import com.service.basic.logic.IBasicService;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.observability.count.CompositeCounters;
import org.pipservices4.observability.log.CompositeLogger;
import org.pipservices4.rpc.commands.CommandSet;
import org.pipservices4.rpc.commands.ICommandable;

public class BasicService
implements IBasicService,
IConfigurable,
IReferenceable,
ICommandable {
    private BasicCommandSet _commandSet;
    private final CompositeLogger _logger = new CompositeLogger();
    private final CompositeCounters _counters = new CompositeCounters();
    private final Object _lock = new Object();
    private String _defaultResponse = "";

    public void configure(ConfigParams config) throws ConfigException {
        this._logger.configure(config);
        this._defaultResponse = config.getAsStringWithDefault("configuration.response", this._defaultResponse);
    }

    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
    }

    public CommandSet getCommandSet() {
        if (this._commandSet == null) {
            this._commandSet = new BasicCommandSet(this);
        }
        return this._commandSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseV1 doSomething(IContext context, RequestV1 request) {
        ResponseV1 response = new ResponseV1();
        Object object = this._lock;
        synchronized (object) {
            response.setValue(this._defaultResponse);
            if (request == null) {
                NullPointerException err = new NullPointerException("NullPointerException");
                this._logger.error(context, (Exception)err, "Processed null request", new Object[0]);
                throw err;
            }
            response.setValue(request.getValue() != null && !request.getValue().isEmpty() ? request.getValue() : this._defaultResponse);
            this._logger.info(context, "Processed request: " + response.getValue(), new Object[0]);
            this._counters.incrementOne("basic.did_something");
        }
        return response;
    }
}

