/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.beacons.service.logic;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import org.pipservices3.beacons.data.version1.BeaconV1;
import org.pipservices3.beacons.data.version1.BeaconV1Schema;
import org.pipservices3.beacons.service.logic.IBeaconsController;
import org.pipservices3.commons.commands.Command;
import org.pipservices3.commons.commands.CommandSet;
import org.pipservices3.commons.commands.ICommand;
import org.pipservices3.commons.convert.TypeCode;
import org.pipservices3.commons.data.FilterParams;
import org.pipservices3.commons.data.PagingParams;
import org.pipservices3.commons.validate.ArraySchema;
import org.pipservices3.commons.validate.FilterParamsSchema;
import org.pipservices3.commons.validate.IValidationRule;
import org.pipservices3.commons.validate.ObjectSchema;
import org.pipservices3.commons.validate.PagingParamsSchema;
import org.pipservices3.commons.validate.Schema;

public class BeaconsCommandSet
extends CommandSet {
    private final IBeaconsController _controller;

    public BeaconsCommandSet(IBeaconsController controller) {
        this._controller = controller;
        this.addCommand(this.makeGetBeaconsCommand());
        this.addCommand(this.makeGetBeaconByIdCommand());
        this.addCommand(this.makeGetBeaconByUdiCommand());
        this.addCommand(this.makeCalculatePositionCommand());
        this.addCommand(this.makeCreateBeaconCommand());
        this.addCommand(this.makeUpdateBeaconCommand());
        this.addCommand(this.makeDeleteBeaconByIdCommand());
    }

    private ICommand makeGetBeaconsCommand() {
        return new Command("get_beacons", (Schema)new ObjectSchema().allowUndefined(true).withOptionalProperty("filter", (Object)new FilterParamsSchema(), new IValidationRule[0]).withOptionalProperty("paging", (Object)new PagingParamsSchema(), new IValidationRule[0]), (correlationId, args) -> {
            FilterParams filter = FilterParams.fromValue((Object)args.get("filter"));
            PagingParams paging = PagingParams.fromValue((Object)args.get("paging"));
            return this._controller.getBeacons(correlationId, filter, paging);
        });
    }

    private ICommand makeGetBeaconByIdCommand() {
        return new Command("get_beacon_by_id", (Schema)new ObjectSchema().allowUndefined(true).withRequiredProperty("beacon_id", (Object)TypeCode.String, new IValidationRule[0]), (correlationId, args) -> {
            String beaconId = args.getAsString("beacon_id");
            return this._controller.getBeaconById(correlationId, beaconId);
        });
    }

    private ICommand makeGetBeaconByUdiCommand() {
        return new Command("get_beacon_by_udi", (Schema)new ObjectSchema().allowUndefined(true).withRequiredProperty("udi", (Object)TypeCode.String, new IValidationRule[0]), (correlationId, args) -> {
            String udi = args.getAsString("udi");
            return this._controller.getBeaconByUdi(correlationId, udi);
        });
    }

    private ICommand makeCalculatePositionCommand() {
        return new Command("calculate_position", (Schema)new ObjectSchema().allowUndefined(true).withRequiredProperty("site_id", (Object)TypeCode.String, new IValidationRule[0]).withRequiredProperty("udis", (Object)new ArraySchema((Object)TypeCode.String), new IValidationRule[0]), (correlationId, args) -> {
            String siteId = args.getAsString("site_id");
            TypeReference<List<String>> type = new TypeReference<List<String>>(this){};
            List udis = (List)args.getAsObject((TypeReference)type, "udis");
            return this._controller.calculatePosition(correlationId, siteId, udis);
        });
    }

    private ICommand makeCreateBeaconCommand() {
        return new Command("create_beacon", (Schema)new ObjectSchema().allowUndefined(true).withRequiredProperty("beacon", (Object)new BeaconV1Schema(), new IValidationRule[0]), (correlationId, args) -> {
            BeaconV1 beacon = (BeaconV1)args.getAsObject(BeaconV1.class, "beacon");
            return this._controller.createBeacon(correlationId, beacon);
        });
    }

    private ICommand makeUpdateBeaconCommand() {
        return new Command("update_beacon", (Schema)new ObjectSchema().allowUndefined(true).withRequiredProperty("beacon", (Object)new BeaconV1Schema(), new IValidationRule[0]), (correlationId, args) -> {
            BeaconV1 beacon = (BeaconV1)args.getAsObject(BeaconV1.class, "beacon");
            return this._controller.updateBeacon(correlationId, beacon);
        });
    }

    private ICommand makeDeleteBeaconByIdCommand() {
        return new Command("delete_beacon_by_id", (Schema)new ObjectSchema().allowUndefined(true).withRequiredProperty("beacon_id", (Object)TypeCode.String, new IValidationRule[0]), (correlationId, args) -> {
            String beaconId = args.getAsString("beacon_id");
            return this._controller.deleteBeaconById(correlationId, beaconId);
        });
    }
}

