/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.beacons.service.persistence;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.pipservices3.beacons.data.version1.BeaconV1;
import org.pipservices3.beacons.service.persistence.IBeaconsPersistence;
import org.pipservices3.commons.data.DataPage;
import org.pipservices3.commons.data.FilterParams;
import org.pipservices3.commons.data.PagingParams;
import org.pipservices3.commons.errors.ApplicationException;
import org.pipservices3.data.persistence.IdentifiableMemoryPersistence;

public class BeaconsMemoryPersistence
extends IdentifiableMemoryPersistence<BeaconV1, String>
implements IBeaconsPersistence {
    public BeaconsMemoryPersistence() {
        super(BeaconV1.class);
        this._maxPageSize = 1000;
    }

    private Predicate<BeaconV1> composeFilter(FilterParams filter) {
        filter = filter != null ? filter : new FilterParams();
        String id = filter.getAsNullableString("id");
        String siteId = filter.getAsNullableString("site_id");
        String label = filter.getAsNullableString("label");
        String udi = filter.getAsNullableString("udi");
        List<String> udis = filter.getAsObject("udis");
        if (udis != null) {
            udis = Arrays.stream(((String)((Object)udis)).split(",")).toList();
        }
        if (udis != null && ((List)udis).isEmpty()) {
            udis = null;
        }
        List finalUdis = udis;
        return item -> {
            if (id != null && !Objects.equals(item.getId(), id)) {
                return false;
            }
            if (siteId != null && !Objects.equals(item.siteId, siteId)) {
                return false;
            }
            if (label != null && !Objects.equals(item.label, label)) {
                return false;
            }
            if (udi != null && !Objects.equals(item.udi, udi)) {
                return false;
            }
            return finalUdis == null || finalUdis.contains(item.udi);
        };
    }

    @Override
    public DataPage<BeaconV1> getPageByFilter(String correlationId, FilterParams filter, PagingParams paging) {
        try {
            return super.getPageByFilter(correlationId, this.composeFilter(filter), paging, null, null);
        }
        catch (ApplicationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public BeaconV1 getOneByUdi(String correlationId, String udi) {
        Optional<BeaconV1> item = this._items.stream().filter(b -> Objects.equals(b.udi, udi)).findFirst();
        if (item.isPresent()) {
            this._logger.trace(correlationId, "Found beacon by %s", new Object[]{udi});
        } else {
            this._logger.trace(correlationId, "Cannot find beacon by %s", new Object[]{udi});
        }
        return item.get();
    }
}

