/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.beacons.service.persistence;

import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.pipservices3.beacons.data.version1.BeaconV1;
import org.pipservices3.beacons.service.persistence.IBeaconsPersistence;
import org.pipservices3.commons.data.DataPage;
import org.pipservices3.commons.data.FilterParams;
import org.pipservices3.commons.data.PagingParams;
import org.pipservices3.mongodb.persistence.IdentifiableMongoDbPersistence;

public class BeaconsMongoDbPersistence
extends IdentifiableMongoDbPersistence<BeaconV1, String>
implements IBeaconsPersistence {
    public BeaconsMongoDbPersistence() {
        super("beacons", BeaconV1.class);
        this._maxPageSize = 1000L;
    }

    private Bson composeFilter(FilterParams filter) {
        String[] udis;
        String udi;
        String label;
        String siteId;
        filter = filter != null ? filter : new FilterParams();
        ArrayList<Bson> criteria = new ArrayList<Bson>();
        String id = filter.getAsNullableString("id");
        if (id != null) {
            criteria.add(Filters.eq((String)"_id", (Object)id));
        }
        if ((siteId = filter.getAsNullableString("site_id")) != null) {
            criteria.add(Filters.eq((String)"site_id", (Object)siteId));
        }
        if ((label = filter.getAsNullableString("label")) != null) {
            criteria.add(Filters.eq((String)"label", (Object)label));
        }
        if ((udi = filter.getAsNullableString("udi")) != null) {
            criteria.add(Filters.eq((String)"udi", (Object)udi));
        }
        if ((udis = filter.getAsObject("udis")) instanceof String) {
            udis = ((String)udis).split(",");
            List<String> udisList = List.of(udis);
            criteria.add(Filters.in((String)"udi", udisList));
        }
        return criteria.size() > 0 ? Filters.and(criteria) : null;
    }

    @Override
    public DataPage<BeaconV1> getPageByFilter(String correlationId, FilterParams filter, PagingParams paging) {
        return super.getPageByFilter(correlationId, this.composeFilter(filter), paging, null, null);
    }

    @Override
    public BeaconV1 getOneByUdi(String correlationId, String udi) {
        Document criteria = new Document("udi", (Object)udi);
        Document item = (Document)this._collection.find((Bson)criteria).first();
        if (item != null) {
            this._logger.trace(correlationId, "Found beacon by %s", new Object[]{udi});
        } else {
            this._logger.trace(correlationId, "Cannot find beacon by %s", new Object[]{udi});
        }
        return (BeaconV1)this.convertToPublic(item);
    }
}

