/*
 * Decompiled with CFR 0.152.
 */
package com.service.cruddata.controllers.version1;

import com.service.cruddata.data.version1.EntityV1;
import com.service.cruddata.logic.IEntitiesService;
import entities.version1.EntitiesGrpc;
import entities.version1.EntitiesPage;
import entities.version1.EntitiesPageRequest;
import entities.version1.Entity;
import entities.version1.EntityIdRequest;
import entities.version1.EntityNameRequest;
import entities.version1.EntityRequest;
import io.grpc.stub.StreamObserver;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.context.Context;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.data.query.DataPage;
import org.pipservices4.data.query.FilterParams;
import org.pipservices4.data.query.PagingParams;
import org.pipservices4.grpc.controllers.GrpcController;
import org.pipservices4.rpc.trace.InstrumentTiming;

public class EntitiesGrpcControllerV1
extends GrpcController {
    private IEntitiesService _service;

    public EntitiesGrpcControllerV1() {
        super(EntitiesGrpc.getServiceDescriptor());
        this._dependencyResolver.put("service", (Object)new Descriptor("service-cruddata", "service", "*", "*", "*"));
    }

    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        super.setReferences(references);
        this._service = (IEntitiesService)this._dependencyResolver.getOneRequired(IEntitiesService.class, "service");
    }

    private void getEntities(EntitiesPageRequest request, StreamObserver<EntitiesPage> responseObserver) {
        Context context = Context.fromTraceId((String)request.getTraceId());
        FilterParams filter = FilterParams.fromValue(request.getFilterMap());
        PagingParams paging = PagingParams.fromValue((Object)request.getPaging());
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.get_entities");
        try {
            DataPage<EntityV1> page = this._service.getEntities((IContext)context, filter, paging);
            EntitiesPage.Builder reply = EntitiesPage.newBuilder();
            page.getData().forEach(item -> {
                EntitiesPage entitiesPage = reply.addData(this.entityToObject((EntityV1)item)).build();
            });
            responseObserver.onNext((Object)reply.build());
            responseObserver.onCompleted();
            timing.endSuccess();
        }
        catch (ApplicationException ex) {
            timing.endFailure((Exception)((Object)ex));
            throw new RuntimeException(ex);
        }
    }

    private void getEntityById(EntityIdRequest request, StreamObserver<Entity> responseObserver) {
        Context context = Context.fromTraceId((String)request.getTraceId());
        String id = request.getEntityId();
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.get_entity_by_id");
        try {
            EntityV1 result = this._service.getEntityById((IContext)context, id);
            responseObserver.onNext((Object)this.entityToObject(result));
            responseObserver.onCompleted();
            timing.endSuccess();
        }
        catch (ApplicationException ex) {
            timing.endFailure((Exception)((Object)ex));
            throw new RuntimeException(ex);
        }
    }

    private void getEntityByName(EntityNameRequest request, StreamObserver<Entity> responseObserver) {
        Context context = Context.fromTraceId((String)request.getTraceId());
        String name = request.getName();
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.get_entity_by_name");
        try {
            EntityV1 result = this._service.getEntityByName((IContext)context, name);
            responseObserver.onNext((Object)this.entityToObject(result));
            responseObserver.onCompleted();
            timing.endSuccess();
        }
        catch (ApplicationException ex) {
            timing.endFailure((Exception)((Object)ex));
            throw new RuntimeException(ex);
        }
    }

    private void createEntity(EntityRequest request, StreamObserver<Entity> responseObserver) {
        Context context = Context.fromTraceId((String)request.getTraceId());
        Entity entityObj = request.getEntity();
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.create_entity");
        try {
            EntityV1 result = this._service.createEntity((IContext)context, this.entityToObject(entityObj));
            responseObserver.onNext((Object)this.entityToObject(result));
            responseObserver.onCompleted();
            timing.endSuccess();
        }
        catch (ApplicationException ex) {
            timing.endFailure((Exception)((Object)ex));
            throw new RuntimeException(ex);
        }
    }

    private void updateEntity(EntityRequest request, StreamObserver<Entity> responseObserver) {
        Context context = Context.fromTraceId((String)request.getTraceId());
        Entity entityObj = request.getEntity();
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.update_entity");
        try {
            EntityV1 result = this._service.updateEntity((IContext)context, this.entityToObject(entityObj));
            responseObserver.onNext((Object)this.entityToObject(result));
            responseObserver.onCompleted();
            timing.endSuccess();
        }
        catch (ApplicationException ex) {
            timing.endFailure((Exception)((Object)ex));
            throw new RuntimeException(ex);
        }
    }

    private void deleteEntityById(EntityIdRequest request, StreamObserver<Entity> responseObserver) {
        Context context = Context.fromTraceId((String)request.getTraceId());
        String id = request.getEntityId();
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.delete_entity_by_id");
        try {
            EntityV1 result = this._service.deleteEntityById((IContext)context, id);
            responseObserver.onNext((Object)this.entityToObject(result));
            responseObserver.onCompleted();
            timing.endSuccess();
        }
        catch (ApplicationException ex) {
            timing.endFailure((Exception)((Object)ex));
            throw new RuntimeException(ex);
        }
    }

    private Entity entityToObject(EntityV1 entity) {
        if (entity == null) {
            return Entity.getDefaultInstance();
        }
        return Entity.newBuilder().setId(entity.getId()).setSiteId(entity.getSiteId()).setType(entity.getType()).setName(entity.getName()).setContent(entity.getContent()).build();
    }

    private EntityV1 entityToObject(Entity entity) {
        return new EntityV1(entity.getId(), entity.getSiteId(), entity.getType(), entity.getName(), entity.getContent());
    }

    public void register() {
        this.registerMethod("get_entities", null, this::getEntities);
        this.registerMethod("get_entity_by_id", null, this::getEntityById);
        this.registerMethod("get_entity_by_name", null, this::getEntityByName);
        this.registerMethod("create_entity", null, this::createEntity);
        this.registerMethod("update_entity", null, this::updateEntity);
        this.registerMethod("delete_entity_by_id", null, this::deleteEntityById);
    }
}

