/*
 * Decompiled with CFR 0.152.
 */
package com.service.cruddata.controllers.version1;

import com.service.cruddata.data.version1.EntityV1;
import com.service.cruddata.data.version1.EntityV1Schema;
import com.service.cruddata.logic.IEntitiesService;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.commons.convert.TypeCode;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.context.Context;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.data.query.DataPage;
import org.pipservices4.data.query.FilterParams;
import org.pipservices4.data.query.PagingParams;
import org.pipservices4.data.validate.FilterParamsSchema;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.ObjectSchema;
import org.pipservices4.data.validate.PagingParamsSchema;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.http.controllers.RestController;
import org.pipservices4.rpc.trace.InstrumentTiming;

public class EntitiesRestControllerV1
extends RestController {
    private IEntitiesService _service;
    private String _swaggerContent;
    private String _swaggerPath;

    public EntitiesRestControllerV1() {
        this._baseRoute = "v1/rest_entities";
        this._dependencyResolver.put("service", (Object)new Descriptor("service-cruddata", "service", "default", "*", "*"));
    }

    public void configure(ConfigParams config) throws ConfigException {
        super.configure(config);
        this._swaggerContent = config.getAsNullableString("swagger.content");
        this._swaggerPath = config.getAsNullableString("swagger.path");
    }

    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        super.setReferences(references);
        this._service = (IEntitiesService)this._dependencyResolver.getOneRequired(IEntitiesService.class, "service");
    }

    public Response getEntities(ContainerRequestContext req) {
        Context context = Context.fromTraceId((String)this.getTraceId(req));
        FilterParams filter = this.getFilterParams(req);
        PagingParams paging = this.getPagingParams(req);
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.get_entities");
        try {
            DataPage<EntityV1> result = this._service.getEntities((IContext)context, filter, paging);
            timing.endSuccess();
            return this.sendResult(result);
        }
        catch (Exception err) {
            timing.endFailure(err);
            return this.sendError(err);
        }
    }

    public Response getEntityById(ContainerRequestContext req) {
        Context context = Context.fromTraceId((String)this.getTraceId(req));
        String id = (String)((List)req.getUriInfo().getPathParameters().get((Object)"entity_id")).get(0);
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.get_entity_by_id");
        try {
            EntityV1 result = this._service.getEntityById((IContext)context, id);
            timing.endSuccess();
            return this.sendResult(result);
        }
        catch (Exception err) {
            timing.endFailure(err);
            return this.sendError(err);
        }
    }

    public Response getEntityByName(ContainerRequestContext req) {
        Context context = Context.fromTraceId((String)this.getTraceId(req));
        String name = (String)((List)req.getUriInfo().getPathParameters().get((Object)"name")).get(0);
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.get_entity_by_name");
        try {
            EntityV1 result = this._service.getEntityByName((IContext)context, name);
            timing.endSuccess();
            return this.sendResult(result);
        }
        catch (Exception err) {
            timing.endFailure(err);
            return this.sendError(err);
        }
    }

    public Response createEntity(ContainerRequestContext req) {
        Context context = Context.fromTraceId((String)this.getTraceId(req));
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.create_entity");
        try {
            EntityV1 data = (EntityV1)JsonConverter.fromJson(EntityV1.class, (String)new String(req.getEntityStream().readAllBytes(), StandardCharsets.UTF_8));
            EntityV1 result = this._service.createEntity((IContext)context, data);
            timing.endSuccess();
            return this.sendResult(result);
        }
        catch (Exception err) {
            timing.endFailure(err);
            return this.sendError(err);
        }
    }

    public Response updateEntity(ContainerRequestContext req) {
        Context context = Context.fromTraceId((String)this.getTraceId(req));
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.update_entity");
        try {
            EntityV1 data = (EntityV1)JsonConverter.fromJson(EntityV1.class, (String)new String(req.getEntityStream().readAllBytes(), StandardCharsets.UTF_8));
            EntityV1 result = this._service.updateEntity((IContext)context, data);
            timing.endSuccess();
            return this.sendResult(result);
        }
        catch (Exception err) {
            timing.endFailure(err);
            return this.sendError(err);
        }
    }

    public Response deleteEntityById(ContainerRequestContext req) {
        Context context = Context.fromTraceId((String)this.getTraceId(req));
        String id = (String)((List)req.getUriInfo().getPathParameters().get((Object)"entity_id")).get(0);
        InstrumentTiming timing = this.instrument((IContext)context, "v1.entities.delete_entity_by_id");
        try {
            EntityV1 result = this._service.deleteEntityById((IContext)context, id);
            timing.endSuccess();
            return this.sendResult(result);
        }
        catch (Exception err) {
            timing.endFailure(err);
            return this.sendError(err);
        }
    }

    protected FilterParams getFilterParams(ContainerRequestContext req) {
        HashMap value = new HashMap(req.getUriInfo().getPathParameters());
        value.remove("skip");
        value.remove("take");
        value.remove("total");
        value.remove("trace_id");
        FilterParams filter = FilterParams.fromValue(value);
        return filter;
    }

    protected PagingParams getPagingParams(ContainerRequestContext req) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("skip", req.getUriInfo().getPathParameters().get((Object)"skip"));
        value.put("take", req.getUriInfo().getPathParameters().get((Object)"take"));
        value.put("total", req.getUriInfo().getPathParameters().get((Object)"total"));
        PagingParams paging = PagingParams.fromValue(value);
        return paging;
    }

    public void register() {
        this.registerRoute("GET", "/entities", (Schema)new ObjectSchema().withOptionalProperty("filter", (Object)new FilterParamsSchema(), new IValidationRule[0]).withOptionalProperty("paging", (Object)new PagingParamsSchema(), new IValidationRule[0]), this::getEntities);
        this.registerRoute("GET", "/entity/{entity_id}", (Schema)new ObjectSchema().withOptionalProperty("entity_id", (Object)TypeCode.String, new IValidationRule[0]), this::getEntityById);
        this.registerRoute("GET", "/entity/name/{name}", (Schema)new ObjectSchema().withOptionalProperty("name", (Object)TypeCode.String, new IValidationRule[0]), this::getEntityByName);
        this.registerRoute("POST", "/entity", (Schema)new ObjectSchema().withRequiredProperty("body", (Object)new EntityV1Schema(), new IValidationRule[0]), this::createEntity);
        this.registerRoute("PUT", "/entity", (Schema)new ObjectSchema().withRequiredProperty("body", (Object)new EntityV1Schema(), new IValidationRule[0]), this::updateEntity);
        this.registerRoute("DELETE", "/entity/{entity_id}", (Schema)new ObjectSchema().withRequiredProperty("entity_id", (Object)TypeCode.String, new IValidationRule[0]), this::deleteEntityById);
        if (this._swaggerContent != null) {
            this.registerOpenApiSpec(this._swaggerContent);
        }
        if (this._swaggerPath != null) {
            this.registerOpenApiSpecFromFile(this._swaggerPath);
        }
    }
}

