/*
 * Decompiled with CFR 0.152.
 */
package com.service.cruddata.logic;

import com.service.cruddata.data.version1.EntityV1;
import com.service.cruddata.data.version1.EntityV1Schema;
import com.service.cruddata.logic.IEntitiesService;
import org.pipservices4.commons.convert.TypeCode;
import org.pipservices4.commons.data.AnyValueMap;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.data.query.FilterParams;
import org.pipservices4.data.query.PagingParams;
import org.pipservices4.data.validate.FilterParamsSchema;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.ObjectSchema;
import org.pipservices4.data.validate.PagingParamsSchema;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.rpc.commands.Command;
import org.pipservices4.rpc.commands.CommandSet;
import org.pipservices4.rpc.commands.ICommand;

public class EntitiesCommandSet
extends CommandSet {
    private final IEntitiesService _service;

    public EntitiesCommandSet(IEntitiesService service) {
        this._service = service;
        this.addCommand(this.makeGetEntitiesCommand());
        this.addCommand(this.makeGetEntityByIdCommand());
        this.addCommand(this.makeGetEntityByNameCommand());
        this.addCommand(this.makeCreateEntityCommand());
        this.addCommand(this.makeUpdateEntityCommand());
        this.addCommand(this.makeDeleteEntityByIdCommand());
    }

    private ICommand makeGetEntitiesCommand() {
        return new Command("get_entities", (Schema)new ObjectSchema().withOptionalProperty("filter", (Object)new FilterParamsSchema(), new IValidationRule[0]).withOptionalProperty("paging", (Object)new PagingParamsSchema(), new IValidationRule[0]), (context, args) -> {
            FilterParams filter = FilterParams.fromValue((Object)args.get("filter"));
            PagingParams paging = PagingParams.fromValue((Object)args.get("paging"));
            return this._service.getEntities(context, filter, paging);
        });
    }

    private ICommand makeGetEntityByIdCommand() {
        return new Command("get_entity_by_id", (Schema)new ObjectSchema().withRequiredProperty("entity_id", (Object)TypeCode.String, new IValidationRule[0]), (context, args) -> {
            String entityId = args.getAsString("entity_id");
            return this._service.getEntityById(context, entityId);
        });
    }

    private ICommand makeGetEntityByNameCommand() {
        return new Command("get_entity_by_name", (Schema)new ObjectSchema().withRequiredProperty("name", (Object)TypeCode.String, new IValidationRule[0]), (context, args) -> {
            String name = args.getAsString("name");
            return this._service.getEntityByName(context, name);
        });
    }

    private ICommand makeCreateEntityCommand() {
        return new Command("create_entity", (Schema)new ObjectSchema().withRequiredProperty("entity", (Object)new EntityV1Schema(), new IValidationRule[0]), (context, args) -> {
            EntityV1 entity = EntitiesCommandSet.extractEntity(args);
            return this._service.createEntity(context, entity);
        });
    }

    private ICommand makeUpdateEntityCommand() {
        return new Command("update_entity", (Schema)new ObjectSchema().withRequiredProperty("entity", (Object)new EntityV1Schema(), new IValidationRule[0]), (context, args) -> {
            EntityV1 entity = EntitiesCommandSet.extractEntity(args);
            return this._service.updateEntity(context, entity);
        });
    }

    private ICommand makeDeleteEntityByIdCommand() {
        return new Command("delete_entity_by_id", (Schema)new ObjectSchema().withRequiredProperty("entity_id", (Object)TypeCode.String, new IValidationRule[0]), (context, args) -> {
            String entityId = args.getAsString("entity_id");
            return this._service.deleteEntityById(context, entityId);
        });
    }

    private static EntityV1 extractEntity(Parameters args) {
        AnyValueMap map = args.getAsMap("entity");
        String id = map.getAsNullableString("id");
        String siteId = map.getAsNullableString("site_id");
        String type = map.getAsNullableString("type");
        String name = map.getAsNullableString("name");
        String content = map.getAsNullableString("content");
        return new EntityV1(id, siteId, type, name, content);
    }
}

