/*
 * Decompiled with CFR 0.152.
 */
package com.service.cruddata.logic;

import com.service.cruddata.data.version1.EntityV1;
import com.service.cruddata.logic.EntitiesCommandSet;
import com.service.cruddata.logic.IEntitiesService;
import com.service.cruddata.persistence.IEntitiesPersistence;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.data.keys.IdGenerator;
import org.pipservices4.data.query.DataPage;
import org.pipservices4.data.query.FilterParams;
import org.pipservices4.data.query.PagingParams;
import org.pipservices4.rpc.commands.CommandSet;
import org.pipservices4.rpc.commands.ICommandable;

public class EntitiesService
implements IEntitiesService,
IConfigurable,
IReferenceable,
ICommandable {
    private IEntitiesPersistence _persistence;
    private EntitiesCommandSet _commandSet;

    public void configure(ConfigParams config) {
    }

    public void setReferences(IReferences references) throws ReferenceException {
        this._persistence = (IEntitiesPersistence)references.getOneRequired(IEntitiesPersistence.class, (Object)new Descriptor("service-cruddata", "persistence", "*", "*", "1.0"));
    }

    public CommandSet getCommandSet() {
        if (this._commandSet == null) {
            this._commandSet = new EntitiesCommandSet(this);
        }
        return this._commandSet;
    }

    @Override
    public DataPage<EntityV1> getEntities(IContext context, FilterParams filter, PagingParams paging) throws ApplicationException {
        return this._persistence.getPageByFilter(context, filter, paging);
    }

    @Override
    public EntityV1 getEntityById(IContext context, String entityId) throws ApplicationException {
        return this._persistence.getOneById(context, entityId);
    }

    @Override
    public EntityV1 getEntityByName(IContext context, String entityName) throws ApplicationException {
        return this._persistence.getOneByName(context, entityName);
    }

    @Override
    public EntityV1 createEntity(IContext context, EntityV1 entity) throws ApplicationException {
        entity.setId(entity.getId() != null ? entity.getId() : IdGenerator.nextLong());
        entity.setType(entity.getType() != null ? entity.getType() : "unknown");
        return this._persistence.create(context, entity);
    }

    @Override
    public EntityV1 updateEntity(IContext context, EntityV1 entity) throws ApplicationException {
        entity.setType(entity.getType() != null ? entity.getType() : "unknown");
        return this._persistence.update(context, entity);
    }

    @Override
    public EntityV1 deleteEntityById(IContext context, String entityId) throws ApplicationException {
        return this._persistence.deleteById(context, entityId);
    }
}

