/*
 * Decompiled with CFR 0.152.
 */
package com.service.cruddata.persistence;

import com.service.cruddata.data.version1.EntityV1;
import com.service.cruddata.persistence.IEntitiesPersistence;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.context.IContext;
import org.pipservices4.data.query.DataPage;
import org.pipservices4.data.query.FilterParams;
import org.pipservices4.data.query.PagingParams;
import org.pipservices4.persistence.persistence.IdentifiableMemoryPersistence;

public class EntitiesMemoryPersistence
extends IdentifiableMemoryPersistence<EntityV1, String>
implements IEntitiesPersistence {
    public EntitiesMemoryPersistence() {
        super(EntityV1.class);
        this._maxPageSize = 1000;
    }

    private Predicate<EntityV1> composeFilter(FilterParams filter) {
        if (filter == null) {
            filter = new FilterParams();
        }
        String id = filter.getAsNullableString("id");
        String siteId = filter.getAsNullableString("site_id");
        String name = filter.getAsNullableString("name");
        Object namesObj = filter.getAsObject("names");
        List names = namesObj instanceof String ? Arrays.asList(((String)namesObj).split(",")) : (namesObj instanceof List ? (List)namesObj : null);
        return item -> {
            if (id != null && !item.getId().equals(id)) {
                return false;
            }
            if (siteId != null && !item.getSiteId().equals(siteId)) {
                return false;
            }
            if (name != null && !item.getName().equals(name)) {
                return false;
            }
            return names == null || names.contains(item.getName());
        };
    }

    @Override
    public DataPage<EntityV1> getPageByFilter(IContext context, FilterParams filter, PagingParams paging) throws ApplicationException {
        return super.getPageByFilter(context, this.composeFilter(filter), paging, null, null);
    }

    @Override
    public EntityV1 getOneByName(IContext context, String name) {
        EntityV1 item = this._items.stream().filter(i -> i.getName().equals(name)).findFirst().orElse(null);
        if (item != null) {
            this._logger.trace(context, "Found entity by %s", new Object[]{name});
        } else {
            this._logger.trace(context, "Cannot find entity by %s", new Object[]{name});
        }
        return item;
    }
}

