/*
 * Decompiled with CFR 0.152.
 */
package com.service.cruddata.persistence;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.model.Filters;
import com.service.cruddata.data.version1.EntityV1;
import com.service.cruddata.persistence.IEntitiesPersistence;
import java.util.ArrayList;
import java.util.Arrays;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.pipservices4.components.context.IContext;
import org.pipservices4.data.query.DataPage;
import org.pipservices4.data.query.FilterParams;
import org.pipservices4.data.query.PagingParams;
import org.pipservices4.mongodb.persistence.IdentifiableMongoDbPersistence;

public class EntitiesMongoDbPersistence
extends IdentifiableMongoDbPersistence<EntityV1, String>
implements IEntitiesPersistence {
    public EntitiesMongoDbPersistence() {
        super("entities", EntityV1.class);
        this._maxPageSize = 1000L;
    }

    private Bson composeFilter(FilterParams filter) {
        String names;
        String name;
        String siteId;
        if (filter == null) {
            filter = new FilterParams();
        }
        ArrayList<Bson> filters = new ArrayList<Bson>();
        String id = filter.getAsNullableString("id");
        if (id != null) {
            filters.add(Filters.or((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)id), Filters.eq((String)"id", (Object)id)}));
        }
        if ((siteId = filter.getAsNullableString("site_id")) != null) {
            filters.add(Filters.eq((String)"site_id", (Object)siteId));
        }
        if ((name = filter.getAsNullableString("name")) != null) {
            filters.add(Filters.eq((String)"name", (Object)name));
        }
        if ((names = filter.getAsNullableString("names")) != null) {
            filters.add(Filters.in((String)"name", Arrays.stream(names.split(",")).toList()));
        }
        return !filters.isEmpty() ? Filters.and(filters).toBsonDocument(BsonDocument.class, MongoClientSettings.getDefaultCodecRegistry()) : null;
    }

    @Override
    public DataPage<EntityV1> getPageByFilter(IContext context, FilterParams filter, PagingParams paging) {
        return super.getPageByFilter(context, this.composeFilter(filter), paging, null, null);
    }

    @Override
    public EntityV1 getOneByName(IContext context, String name) {
        Document item;
        EntityV1 res;
        Document filterCondition = new Document();
        if (name != null) {
            filterCondition.put("name", (Object)name);
        }
        if ((res = (EntityV1)this.convertToPublic(item = (Document)this._collection.find((Bson)filterCondition).first())) != null) {
            this._logger.trace(context, "Found entity by %s", new Object[]{name});
        } else {
            this._logger.trace(context, "Cannot find entity by %s", new Object[]{name});
        }
        return res;
    }
}

