/*
 * Decompiled with CFR 0.152.
 */
package io.nerv.core.license;

import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.net.NetUtil;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import io.nerv.properties.EvaConfig;
import java.io.File;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="eva.license", name={"enable"}, havingValue="true")
public class LicenseVerify {
    private static final Logger log = LoggerFactory.getLogger(LicenseVerify.class);
    @Autowired
    private EvaConfig evaConfig;
    @Autowired
    private LicenseManager licenseManager;

    public void init() {
        try {
            System.out.println(new File(this.evaConfig.getLicense().getLicense()).getAbsolutePath());
            ClassPathResource classPathResource = new ClassPathResource(this.evaConfig.getLicense().getLicense());
            this.licenseManager.install(classPathResource.getFile());
            log.info("\u5b89\u88c5\u8bc1\u4e66\u6210\u529f!");
        }
        catch (Exception e) {
            log.error("\u6388\u6743\u5df2\u8fc7\u671f, \u5b89\u88c5\u8bc1\u4e66\u5931\u8d25!", (Throwable)e);
            Runtime.getRuntime().halt(1);
        }
    }

    public void install() {
        try {
            this.licenseManager.install(new File(this.evaConfig.getLicense().getLicense()));
            log.info("\u5b89\u88c5\u8bc1\u4e66\u6210\u529f!");
        }
        catch (Exception e) {
            log.error("\u6388\u6743\u5df2\u8fc7\u671f, \u5b89\u88c5\u8bc1\u4e66\u5931\u8d25!", (Throwable)e);
            Runtime.getRuntime().halt(1);
        }
    }

    public boolean vertify() {
        try {
            String localMac;
            LicenseContent verify = this.licenseManager.verify();
            log.info("\u9a8c\u8bc1\u8bc1\u4e66\u6210\u529f!");
            Map extra = (Map)verify.getExtra();
            String ip = (String)extra.get("ip");
            InetAddress inetAddress = InetAddress.getLocalHost();
            String localIp = inetAddress.toString().split("/")[1];
            if (!Objects.equals(ip, localIp)) {
                log.error("IP \u5730\u5740\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                return false;
            }
            String mac = (String)extra.get("mac");
            if (!Objects.equals(mac, localMac = this.getLocalMac(inetAddress))) {
                log.error("MAC \u5730\u5740\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                return false;
            }
            log.info("IP\u3001MAC\u5730\u5740\u9a8c\u8bc1\u901a\u8fc7");
            return true;
        }
        catch (LicenseContentException ex) {
            log.error("\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f!", (Throwable)ex);
            return false;
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u8bc1\u4e66\u5931\u8d25!", (Throwable)e);
            return false;
        }
    }

    private String getLocalMac(InetAddress inetAddress) {
        return NetUtil.getMacAddress((InetAddress)inetAddress).toUpperCase();
    }
}

