/*
 * Decompiled with CFR 0.152.
 */
package io.nerv.core.license;

import io.nerv.core.enums.BizCode;
import io.nerv.core.enums.BizCodeEnum;
import io.nerv.core.license.LicenseVerify;
import io.nerv.core.mvc.vo.Response;
import io.nerv.core.util.JsonUtil;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
@ConditionalOnProperty(prefix="eva.license", name={"enable"}, havingValue="true")
public class LicenseCheckInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private JsonUtil jsonUtil;
    @Autowired
    private LicenseVerify licenseVerify;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LicenseVerify licenseVerify = new LicenseVerify();
        boolean verifyResult = licenseVerify.vertify();
        if (verifyResult) {
            return true;
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.setStatus(200);
        try (PrintWriter printWriter = response.getWriter();){
            printWriter.write(this.jsonUtil.toJSONString((Object)new Response().failure((BizCode)BizCodeEnum.LICENSE_LICENSEHASEXPIRED)));
            printWriter.flush();
        }
        return false;
    }
}

