/*
 * Decompiled with CFR 0.152.
 */
package io.nerv.config;

import io.nerv.core.license.LicenseCheckInterceptor;
import io.nerv.properties.EvaConfig;
import java.nio.charset.Charset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(prefix="eva.license", name={"enable"}, havingValue="true")
public class WebConfigurer
implements WebMvcConfigurer {
    @Autowired
    private LicenseCheckInterceptor licenseCheckInterceptor;
    @Autowired
    private EvaConfig evaConfig;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.licenseCheckInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(this.evaConfig.getSecurity().getPermit());
    }

    @Bean
    public HttpMessageConverter<String> responseBodyConverter() {
        return new StringHttpMessageConverter(Charset.forName("UTF-8"));
    }
}

