/*
 * Decompiled with CFR 0.152.
 */
package io.nerv.common.license;

import io.nerv.common.enums.BizCode;
import io.nerv.common.enums.BizCodeEnum;
import io.nerv.common.license.LicenseVerify;
import io.nerv.common.mvc.vo.Response;
import io.nerv.common.util.json.JsonUtil;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

@Component
@ConditionalOnProperty(prefix="eva.license", name={"enable"}, havingValue="true")
public class LicenseCheckInterceptor
implements AsyncHandlerInterceptor {
    private final LicenseVerify licenseVerify;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean verifyResult = this.licenseVerify.vertify();
        if (verifyResult) {
            return true;
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.setStatus(200);
        try (PrintWriter printWriter = response.getWriter();){
            printWriter.write(JsonUtil.toJson((Object)new Response().failure((BizCode)BizCodeEnum.LICENSE_LICENSEHASEXPIRED)));
            printWriter.flush();
        }
        return false;
    }

    public LicenseCheckInterceptor(LicenseVerify licenseVerify) {
        this.licenseVerify = licenseVerify;
    }
}

