/*
 * Decompiled with CFR 0.152.
 */
package io.nerv.core.license;

import io.nerv.core.enums.BizCode;
import io.nerv.core.enums.BizCodeEnum;
import io.nerv.core.license.LicenseVerify;
import io.nerv.core.mvc.vo.Response;
import io.nerv.core.util.json.JsonUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

@Component
@ConditionalOnProperty(prefix="eva.license", name={"enable"}, havingValue="true")
public class LicenseCheckInterceptor
implements AsyncHandlerInterceptor {
    private final LicenseVerify licenseVerify;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean verifyResult = this.licenseVerify.vertify();
        if (verifyResult) {
            return true;
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.setStatus(200);
        try (PrintWriter printWriter = response.getWriter();){
            printWriter.write(JsonUtil.toJson((Object)new Response().failure((BizCode)BizCodeEnum.LICENSE_LICENSEHASEXPIRED)));
            printWriter.flush();
        }
        return false;
    }

    public LicenseCheckInterceptor(LicenseVerify licenseVerify) {
        this.licenseVerify = licenseVerify;
    }
}

