/*
 * Decompiled with CFR 0.152.
 */
package io.nerv.core.license;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultKeyStoreParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import io.nerv.core.license.LicenseVerify;
import io.nerv.core.properties.EvaConfig;
import java.util.prefs.Preferences;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="eva.license", name={"enable"}, havingValue="true")
public class LicenseManagerHolder {
    private final EvaConfig evaConfig;

    @Bean
    public LicenseManager getLicenseManager() {
        return new LicenseManager(this.initLicenseParams());
    }

    private LicenseParam initLicenseParams() {
        Class<LicenseVerify> clazz = LicenseVerify.class;
        Preferences pre = Preferences.userNodeForPackage(clazz);
        DefaultCipherParam cipherParam = new DefaultCipherParam(this.evaConfig.getLicense().getKeystorePwd());
        DefaultKeyStoreParam pubStoreParam = new DefaultKeyStoreParam(clazz, this.evaConfig.getLicense().getPath(), this.evaConfig.getLicense().getAlias(), this.evaConfig.getLicense().getKeystorePwd(), null);
        return new DefaultLicenseParam(this.evaConfig.getLicense().getSubject(), pre, (KeyStoreParam)pubStoreParam, (CipherParam)cipherParam);
    }

    public LicenseManagerHolder(EvaConfig evaConfig) {
        this.evaConfig = evaConfig;
    }
}

