/*
 * Decompiled with CFR 0.152.
 */
package io.nerv.pay.alipay.util;

import cn.hutool.json.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import io.nerv.config.AlipayConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlipayHelper {
    private static final Logger log = LoggerFactory.getLogger(AlipayHelper.class);
    private final AlipayConfig alipayConfig;
    private final AlipayClient alipayClient;

    public AlipayTradeQueryResponse payquery(String out_trade_no) throws AlipayApiException {
        AlipayTradeQueryRequest queryRequest = new AlipayTradeQueryRequest();
        JSONObject json = new JSONObject();
        json.put("out_trade_no", (Object)out_trade_no);
        queryRequest.setBizContent(json.toString());
        return (AlipayTradeQueryResponse)this.alipayClient.execute((AlipayRequest)queryRequest);
    }

    public String prepay(String orderNo, String totalAmount, String subject, String timeout) throws AlipayApiException {
        AlipayTradePrecreateRequest request = new AlipayTradePrecreateRequest();
        JSONObject json = new JSONObject();
        json.put("out_trade_no", (Object)orderNo);
        json.put("total_amount", (Object)totalAmount);
        json.put("subject", (Object)subject);
        json.put("timeout_express", (Object)timeout);
        log.debug(json.toString());
        request.setNotifyUrl(this.alipayConfig.getNotify_url());
        request.setBizContent(json.toString());
        AlipayTradePrecreateResponse response = (AlipayTradePrecreateResponse)this.alipayClient.execute((AlipayRequest)request);
        if (response.isSuccess()) {
            log.debug("\u8c03\u7528\u6210\u529f");
            return response.getQrCode();
        }
        log.debug("\u8c03\u7528\u5931\u8d25");
        return null;
    }

    public AlipayHelper(AlipayConfig alipayConfig, AlipayClient alipayClient) {
        this.alipayConfig = alipayConfig;
        this.alipayClient = alipayClient;
    }
}

