/*
 * Decompiled with CFR 0.152.
 */
package io.nerv.core.pay.alipay.response;

import cn.hutool.core.util.StrUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"alipay"})
public class AlipayResponseCtrl {
    private static final Logger log = LoggerFactory.getLogger(AlipayResponseCtrl.class);
    private static final String APP_ID = "2018092561531306";
    private static final String CHARSET = "UTF-8";
    private static final String SIGN_TYPE = "RSA2";
    private static final String ALIPAY_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAghqnxLzdt+sZmjbXJ19mYmvOjckNwA5Nwrvc+XcgZzuHdT+HmERiLS1OC/f5ioLkzg31+IB6ECX1ErJANQXAOLBbmUm8A/SK+dchf4Qm8EjP+e6cygi+p6bDG5BtV1k+PQYivm0uVJgosErD9qj6bptwYiFQ2Pe70z4groZxvUJEfKFngQ1/oarkaAt5KtlLlyfEPnttHb39QA3t9htdzLrsi0qIq3uecjpFIEBRHHZjm81fHbuBZN37oaQ7CxlKbohZMzxtdFYswKY4E1oLWZ1L2jvDtUEOa4PrsmLim8EI1MZUNoB0aRrVLUDRJsqNdHkNNDh2jZoOzlsFBMCh1wIDAQAB";

    @PostMapping(value={"callback"})
    public void alipayCallback(HttpServletRequest request, HttpServletResponse response) {
        String message = "success";
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if ("sign_type".equals(parameterName) || StrUtil.isBlank((CharSequence)request.getParameter(parameterName))) continue;
            params.put(parameterName, request.getParameter(parameterName));
        }
        boolean signVerified = false;
        try {
            signVerified = AlipaySignature.rsaCheckV2(params, (String)ALIPAY_PUBLIC_KEY, (String)CHARSET, (String)SIGN_TYPE);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            message = "failed";
        }
        if (signVerified) {
            log.info("\u652f\u4ed8\u5b9d\u9a8c\u8bc1\u7b7e\u540d\u6210\u529f\uff01");
            if (!APP_ID.equals(params.get("app_id"))) {
                log.info("\u4e0e\u4ed8\u6b3e\u65f6\u7684appid\u4e0d\u540c\uff0c\u6b64\u4e3a\u5f02\u5e38\u901a\u77e5\uff0c\u5e94\u5ffd\u7565\uff01");
                message = "failed";
            } else {
                String outtradeno = (String)params.get("out_trade_no");
                String status = (String)params.get("trade_status");
                if ("WAIT_BUYER_PAY".equals(status)) {
                    log.info(outtradeno + "\u8ba2\u5355\u7684\u72b6\u6001\u6b63\u5728\u7b49\u5f85\u7528\u6237\u4ed8\u6b3e");
                } else if ("TRADE_CLOSED".equals(status)) {
                    log.info(outtradeno + "\u8ba2\u5355\u7684\u72b6\u6001\u5df2\u7ecf\u5173\u95ed");
                } else if ("TRADE_SUCCESS".equals(status) || "TRADE_FINISHED".equals(status)) {
                    log.info("(\u652f\u4ed8\u5b9d\u8ba2\u5355\u53f7:" + outtradeno + "\u4ed8\u6b3e\u6210\u529f)");
                }
            }
        } else {
            message = "failed";
            log.info("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff01");
        }
        try (BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            out.write(message.getBytes());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

