/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.DefaultKeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.DefaultTrustManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.Protocols$;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ahc.AhcConfigBuilder$;
import play.api.libs.ws.ahc.AhcLoggerFactory;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.shaded.ahc.io.netty.handler.ssl.SslContextBuilder;
import play.shaded.ahc.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.SslEngineFactory;
import play.shaded.ahc.org.asynchttpclient.netty.ssl.JsseSslEngineFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\r\u001a\u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\bi\u0001\u0011\r\u0011\"\u00056\u0011\u0019A\u0005\u0001)A\u0005m!9\u0011\n\u0001b\u0001\n\u0003Q\u0005BB&\u0001A\u0003%\u0011\b\u0003\u0005M\u0001\t\u0007I\u0011A\rN\u0011\u0019)\u0006\u0001)A\u0005\u001d\"Aa\u000b\u0001b\u0001\n\u0003Ir\u000b\u0003\u0004\\\u0001\u0001\u0006I\u0001\u0017\u0005\u00069\u0002!\t!\u0018\u0005\u0006=\u0002!\ta\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u00028\u0001!\t!!\u000f\b\u0013\u0005\r\u0013$!A\t\u0002\u0005\u0015c\u0001\u0003\r\u001a\u0003\u0003E\t!a\u0012\t\rA*B\u0011AA%\u0011%\tY%FI\u0001\n\u0003\tiE\u0001\tBQ\u000e\u001cuN\u001c4jO\n+\u0018\u000e\u001c3fe*\u0011!dG\u0001\u0004C\"\u001c'B\u0001\u000f\u001e\u0003\t98O\u0003\u0002\u001f?\u0005!A.\u001b2t\u0015\t\u0001\u0013%A\u0002ba&T\u0011AI\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g-A\u0005bQ\u000e\u001cuN\u001c4jOB\u0011QFL\u0007\u00023%\u0011q&\u0007\u0002\u0012\u0003\"\u001cwkU\"mS\u0016tGoQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u00023gA\u0011Q\u0006\u0001\u0005\bW\t\u0001\n\u00111\u0001-\u0003E\tG\rZ\"vgR|WnU3ui&twm]\u000b\u0002mA!aeN\u001d:\u0013\tAtEA\u0005Gk:\u001cG/[8ocA\u0011!(\u0012\b\u0003w\rk\u0011\u0001\u0010\u0006\u0003{y\nq\"Y:z]\u000eDG\u000f\u001e9dY&,g\u000e\u001e\u0006\u0003\u007f\u0001\u000b1a\u001c:h\u0015\tQ\u0012I\u0003\u0002CC\u000511\u000f[1eK\u0012L!\u0001\u0012\u001f\u00029\u0011+g-Y;mi\u0006\u001b\u0018P\\2IiR\u00048\t\\5f]R\u001cuN\u001c4jO&\u0011ai\u0012\u0002\b\u0005VLG\u000eZ3s\u0015\t!E(\u0001\nbI\u0012\u001cUo\u001d;p[N+G\u000f^5oON\u0004\u0013a\u00022vS2$WM]\u000b\u0002s\u0005A!-^5mI\u0016\u0014\b%\u0001\u0004m_\u001e<WM]\u000b\u0002\u001dB\u0011qjU\u0007\u0002!*\u0011\u0011KU\u0001\u0006g24GG\u001b\u0006\u0002\u007f%\u0011A\u000b\u0015\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005iAn\\4hKJ4\u0015m\u0019;pef,\u0012\u0001\u0017\t\u0003[eK!AW\r\u0003!\u0005C7\rT8hO\u0016\u0014h)Y2u_JL\u0018A\u00047pO\u001e,'OR1di>\u0014\u0018\u0010I\u0001\nG>tg-[4ve\u0016$\u0012!O\u0001\u0006EVLG\u000e\u001a\u000b\u0002AB\u00111(Y\u0005\u0003Er\u0012Q#Q:z]\u000eDE\u000f\u001e9DY&,g\u000e^\"p]\u001aLw-\u0001\tn_\u0012Lg-_+oI\u0016\u0014H._5oOR\u0011!'\u001a\u0005\u0006M6\u0001\rAN\u0001\u0007[>$\u0017NZ=\u0002\u0017\r|gNZ5hkJ,wk\u0015\u000b\u0003S2\u0004\"A\n6\n\u0005-<#\u0001B+oSRDQa\u000b\bA\u00021\n!cY8oM&<WO]3Qe>$xnY8mgR\u0019q.`@\u0011\u0007\u0019\u0002(/\u0003\u0002rO\t)\u0011I\u001d:bsB\u00111O\u001f\b\u0003ib\u0004\"!^\u0014\u000e\u0003YT!a^\u0012\u0002\rq\u0012xn\u001c;?\u0013\tIx%\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u0014aa\u0015;sS:<'BA=(\u0011\u0015qx\u00021\u0001p\u0003E)\u00070[:uS:<\u0007K]8u_\u000e|Gn\u001d\u0005\b\u0003\u0003y\u0001\u0019AA\u0002\u0003%\u00198\u000f\\\"p]\u001aLw\r\u0005\u0003\u0002\u0006\u0005]QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0007M\u001cHN\u0003\u0003\u0002\u000e\u0005=\u0011!C:tY\u000e|gNZ5h\u0015\u0011\t\t\"a\u0005\u0002\u0011QL\b/Z:bM\u0016T!!!\u0006\u0002\u0007\r|W.\u0003\u0003\u0002\u001a\u0005\u001d!!E*T\u0019\u000e{gNZ5h'\u0016$H/\u001b8hg\u0006)2m\u001c8gS\u001e,(/Z\"ja\",'oU;ji\u0016\u001cH#B8\u0002 \u0005\r\u0002BBA\u0011!\u0001\u0007q.A\bfq&\u001cH/\u001b8h\u0007&\u0004\b.\u001a:t\u0011\u001d\t\t\u0001\u0005a\u0001\u0003\u0007\tAbY8oM&<WO]3T'2#2![A\u0015\u0011\u001d\t\t!\u0005a\u0001\u0003\u0007\taCY;jY\u0012\\U-_'b]\u0006<WM\u001d$bGR|'/\u001f\u000b\u0005\u0003_\t)\u0004\u0005\u0003\u0002\u0006\u0005E\u0012\u0002BA\u001a\u0003\u000f\u0011\u0001dS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z/J\f\u0007\u000f]3s\u0011\u001d\tIA\u0005a\u0001\u0003\u0007\t\u0001DY;jY\u0012$&/^:u\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z)\u0011\tY$!\u0011\u0011\t\u0005\u0015\u0011QH\u0005\u0005\u0003\u007f\t9A\u0001\u000eUeV\u001cH/T1oC\u001e,'OR1di>\u0014\u0018p\u0016:baB,'\u000fC\u0004\u0002\nM\u0001\r!a\u0001\u0002!\u0005C7mQ8oM&<')^5mI\u0016\u0014\bCA\u0017\u0016'\t)R\u0005\u0006\u0002\u0002F\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!a\u0014+\u00071\n\tf\u000b\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013!C;oG\",7m[3e\u0015\r\tifJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA1\u0003/\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class AhcConfigBuilder {
    public final AhcWSClientConfig play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig;
    private final Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> addCustomSettings;
    private final DefaultAsyncHttpClientConfig.Builder builder;
    private final Logger logger;
    private final AhcLoggerFactory loggerFactory;

    public static AhcWSClientConfig $lessinit$greater$default$1() {
        return AhcConfigBuilder$.MODULE$.$lessinit$greater$default$1();
    }

    public Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> addCustomSettings() {
        return this.addCustomSettings;
    }

    public DefaultAsyncHttpClientConfig.Builder builder() {
        return this.builder;
    }

    public Logger logger() {
        return this.logger;
    }

    public AhcLoggerFactory loggerFactory() {
        return this.loggerFactory;
    }

    public DefaultAsyncHttpClientConfig.Builder configure() {
        WSClientConfig config = this.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig.wsClientConfig();
        this.configureWS(this.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig);
        this.configureSSL(config.ssl());
        return (DefaultAsyncHttpClientConfig.Builder)this.addCustomSettings().apply((Object)this.builder());
    }

    public AsyncHttpClientConfig build() {
        return this.configure().build();
    }

    public AhcConfigBuilder modifyUnderlying(Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> modify) {
        return new AhcConfigBuilder(this, modify){
            private final Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> addCustomSettings;
            private final DefaultAsyncHttpClientConfig.Builder builder;

            public Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> addCustomSettings() {
                return this.addCustomSettings;
            }

            public DefaultAsyncHttpClientConfig.Builder builder() {
                return this.builder;
            }
            {
                this.addCustomSettings = modify$1.compose($outer.addCustomSettings());
                this.builder = $outer.builder();
            }
        };
    }

    public void configureWS(AhcWSClientConfig ahcConfig) {
        WSClientConfig config = ahcConfig.wsClientConfig();
        this.builder().setConnectTimeout(AhcConfigBuilder.toMillis$1(config.connectionTimeout())).setReadTimeout(AhcConfigBuilder.toMillis$1(config.idleTimeout())).setRequestTimeout(AhcConfigBuilder.toMillis$1(config.requestTimeout())).setFollowRedirect(config.followRedirects()).setUseProxyProperties(config.useProxyProperties()).setCompressionEnforced(config.compressionEnabled());
        config.userAgent().foreach((Function1 & Serializable)x$1 -> this.builder().setUserAgent(x$1));
        this.builder().setMaxConnectionsPerHost(ahcConfig.maxConnectionsPerHost());
        this.builder().setMaxConnections(ahcConfig.maxConnectionsTotal());
        this.builder().setConnectionTtl(AhcConfigBuilder.toMillis$1(ahcConfig.maxConnectionLifetime()));
        this.builder().setPooledConnectionIdleTimeout(AhcConfigBuilder.toMillis$1(ahcConfig.idleConnectionInPoolTimeout()));
        this.builder().setConnectionPoolCleanerPeriod(AhcConfigBuilder.toMillis$1(ahcConfig.connectionPoolCleanerPeriod()));
        this.builder().setMaxRedirects(ahcConfig.maxNumberOfRedirects());
        this.builder().setMaxRequestRetry(ahcConfig.maxRequestRetry());
        this.builder().setDisableUrlEncodingForBoundRequests(ahcConfig.disableUrlEncoding());
        this.builder().setKeepAlive(ahcConfig.keepAlive());
        this.builder().setShutdownQuietPeriod(0);
        this.builder().setShutdownTimeout(0);
        this.builder().setUseLaxCookieEncoder(ahcConfig.useLaxCookieEncoder());
        if (!ahcConfig.useCookieStore()) {
            this.builder().setCookieStore(null);
            return;
        }
    }

    public String[] configureProtocols(String[] existingProtocols, SSLConfigSettings sslConfig) {
        String[] stringArray;
        Option option = sslConfig.enabledProtocols();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq configuredProtocols = (Seq)some.value();
            Object object = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
            stringArray = (String[])((IterableOnceOps)configuredProtocols.filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(object, (Object)elem)))).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (None$.MODULE$.equals(option)) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
            stringArray = (String[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])Protocols$.MODULE$.recommendedProtocols()), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(object, (Object)elem)))), ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)option);
        }
        String[] definedProtocols = stringArray;
        return definedProtocols;
    }

    public String[] configureCipherSuites(String[] existingCiphers, SSLConfigSettings sslConfig) {
        String[] stringArray;
        Option option = sslConfig.enabledCipherSuites();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq configuredCiphers = (Seq)some.value();
            stringArray = (String[])((IterableOnceOps)configuredCiphers.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])existingCiphers), (Object)x$1)))).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (None$.MODULE$.equals(option)) {
            stringArray = existingCiphers;
        } else {
            throw new MatchError((Object)option);
        }
        String[] definedCiphers = stringArray;
        return definedCiphers;
    }

    public void configureSSL(SSLConfigSettings sslConfig) {
        SSLContext sSLContext;
        if (sslConfig.default()) {
            this.logger().info("buildSSLContext: play.ws.ssl.default is true, using default SSLContext");
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = this.buildKeyManagerFactory(sslConfig);
            TrustManagerFactoryWrapper trustManagerFactory = this.buildTrustManagerFactory(sslConfig);
            sSLContext = new ConfigSSLContextBuilder((com.typesafe.sslconfig.util.LoggerFactory)this.loggerFactory(), sslConfig, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = this.configureProtocols(defaultProtocols, sslConfig);
        defaultParams.setProtocols(protocols);
        this.builder().setEnabledProtocols(protocols);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        String[] cipherSuites = this.configureCipherSuites(defaultCiphers, sslConfig);
        defaultParams.setCipherSuites(cipherSuites);
        this.builder().setEnabledCipherSuites(cipherSuites);
        this.builder().setUseInsecureTrustManager(sslConfig.loose().acceptAnyCertificate());
        if (sslConfig.loose().acceptAnyCertificate()) {
            this.builder().setSslContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
            return;
        }
        this.builder().setSslEngineFactory((SslEngineFactory)new JsseSslEngineFactory(sslContext));
    }

    public KeyManagerFactoryWrapper buildKeyManagerFactory(SSLConfigSettings ssl) {
        return new DefaultKeyManagerFactoryWrapper(ssl.keyManagerConfig().algorithm());
    }

    public TrustManagerFactoryWrapper buildTrustManagerFactory(SSLConfigSettings ssl) {
        return new DefaultTrustManagerFactoryWrapper(ssl.trustManagerConfig().algorithm());
    }

    private static final int toMillis$1(Duration duration) {
        if (duration.isFinite()) {
            return (int)duration.toMillis();
        }
        return -1;
    }

    public AhcConfigBuilder(AhcWSClientConfig ahcConfig) {
        this.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig = ahcConfig;
        this.addCustomSettings = (Function1 & Serializable)x -> (DefaultAsyncHttpClientConfig.Builder)Predef$.MODULE$.identity(x);
        this.builder = new DefaultAsyncHttpClientConfig.Builder();
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.loggerFactory = new AhcLoggerFactory(LoggerFactory.getILoggerFactory());
    }
}

