/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.javadsl.AsPublisher;
import org.apache.pekko.stream.javadsl.Sink;
import org.apache.pekko.stream.javadsl.Source;
import org.apache.pekko.util.ByteString;
import org.reactivestreams.Publisher;
import play.api.libs.ws.ahc.FormUrlEncodedParser;
import play.libs.oauth.OAuth;
import play.libs.ws.BodyWritable;
import play.libs.ws.InMemoryBodyWritable;
import play.libs.ws.SourceBodyWritable;
import play.libs.ws.StandaloneWSRequest;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.WSAuthInfo;
import play.libs.ws.WSAuthScheme;
import play.libs.ws.WSCookie;
import play.libs.ws.WSRequestExecutor;
import play.libs.ws.WSRequestFilter;
import play.libs.ws.WSSignatureCalculator;
import play.libs.ws.ahc.StandaloneAhcWSClient;
import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderValues;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.DefaultCookie;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.RequestBuilder;
import play.shaded.ahc.org.asynchttpclient.SignatureCalculator;
import play.shaded.ahc.org.asynchttpclient.oauth.OAuthSignatureCalculator;
import play.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import scala.concurrent.ExecutionContext;

public class StandaloneAhcWSRequest
implements StandaloneWSRequest {
    private static final Duration INFINITE = Duration.ofMillis(-1L);
    private BodyWritable<?> bodyWritable;
    private String url;
    private String method = "GET";
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();
    private final List<WSCookie> cookies = new ArrayList<WSCookie>();
    private WSAuthInfo auth;
    private WSSignatureCalculator calculator;
    private final StandaloneAhcWSClient client;
    private final Materializer materializer;
    private Duration timeout = Duration.ZERO;
    private Boolean followRedirects = null;
    private Boolean disableUrlEncoding = null;
    private String virtualHost = null;
    private final List<WSRequestFilter> filters = new ArrayList<WSRequestFilter>();

    public StandaloneAhcWSRequest(StandaloneAhcWSClient standaloneAhcWSClient, String string, Materializer materializer) {
        this.client = standaloneAhcWSClient;
        try {
            URL uRL = new URL(string);
            this.url = string;
            this.materializer = materializer;
            this.bodyWritable = null;
            String string2 = uRL.getUserInfo();
            if (string2 != null) {
                this.setAuth(string2);
            }
            if (uRL.getQuery() != null) {
                this.setQueryString(uRL.getQuery());
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public StandaloneAhcWSRequest setRequestFilter(WSRequestFilter wSRequestFilter) {
        this.filters.add(wSRequestFilter);
        return this;
    }

    public StandaloneAhcWSRequest addHeader(String string, String string2) {
        StandaloneAhcWSRequest.addValueTo(this.headers, string, string2);
        return this;
    }

    public StandaloneAhcWSRequest setHeaders(Map<String, List<String>> map) {
        this.headers.clear();
        this.headers.putAll(map);
        return this;
    }

    public StandaloneAhcWSRequest setQueryString(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length > 2) {
                throw new RuntimeException(new MalformedURLException("QueryString parameter should not have more than 2 = per part"));
            }
            if (stringArray2.length == 2) {
                this.addQueryParameter(stringArray2[0], stringArray2[1]);
                continue;
            }
            if (stringArray2.length == 1 && string2.charAt(0) != '=') {
                this.addQueryParameter(stringArray2[0], null);
                continue;
            }
            throw new RuntimeException(new MalformedURLException("QueryString part should not start with an = and not be empty"));
        }
        return this;
    }

    public StandaloneAhcWSRequest addQueryParameter(String string, String string2) {
        StandaloneAhcWSRequest.addValueTo(this.queryParameters, string, string2);
        return this;
    }

    public StandaloneAhcWSRequest setQueryString(Map<String, List<String>> map) {
        this.queryParameters.clear();
        this.queryParameters.putAll(map);
        return this;
    }

    public StandaloneAhcWSRequest addCookie(WSCookie wSCookie) {
        if (wSCookie == null) {
            throw new NullPointerException("Trying to add a null WSCookie");
        }
        this.cookies.add(wSCookie);
        return this;
    }

    public StandaloneAhcWSRequest addCookies(WSCookie ... wSCookieArray) {
        Arrays.asList(wSCookieArray).forEach(this::addCookie);
        return this;
    }

    public StandaloneAhcWSRequest setCookies(List<WSCookie> list) {
        this.cookies.clear();
        list.forEach(this::addCookie);
        return this;
    }

    public StandaloneAhcWSRequest setAuth(String string) {
        if (string.isEmpty()) {
            throw new RuntimeException(new MalformedURLException("userInfo should not be empty"));
        }
        int n = string.indexOf(58);
        this.auth = n == 0 ? new WSAuthInfo("", string.substring(1), WSAuthScheme.BASIC) : (n == -1 ? new WSAuthInfo(string, "", WSAuthScheme.BASIC) : new WSAuthInfo(string.substring(0, n), string.substring(n + 1), WSAuthScheme.BASIC));
        return this;
    }

    public StandaloneAhcWSRequest setAuth(WSAuthInfo wSAuthInfo) {
        this.auth = wSAuthInfo;
        return this;
    }

    public StandaloneAhcWSRequest sign(WSSignatureCalculator wSSignatureCalculator) {
        this.calculator = wSSignatureCalculator;
        return this;
    }

    public StandaloneAhcWSRequest setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
        return this;
    }

    public StandaloneAhcWSRequest setDisableUrlEncoding(boolean bl) {
        this.disableUrlEncoding = bl;
        return this;
    }

    public StandaloneAhcWSRequest setVirtualHost(String string) {
        this.virtualHost = string;
        return this;
    }

    public StandaloneAhcWSRequest setRequestTimeout(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Timeout must not be null.");
        }
        this.timeout = duration;
        return this;
    }

    public StandaloneAhcWSRequest setContentType(String string) {
        return this.addHeader(HttpHeaderNames.CONTENT_TYPE.toString(), string);
    }

    public Optional<String> getContentType() {
        return this.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
    }

    public StandaloneAhcWSRequest setUrl(String string) {
        this.url = string;
        return this;
    }

    public StandaloneAhcWSRequest setMethod(String string) {
        this.method = string;
        return this;
    }

    public StandaloneAhcWSRequest setBody(BodyWritable bodyWritable) {
        this.bodyWritable = bodyWritable;
        String string2 = bodyWritable.contentType();
        if (string2 != null && this.headers.keySet().stream().noneMatch(string -> string.equalsIgnoreCase(HttpHeaderNames.CONTENT_TYPE.toString()))) {
            this.addHeader(HttpHeaderNames.CONTENT_TYPE.toString(), bodyWritable.contentType());
        }
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public List<WSCookie> getCookies() {
        return new ArrayList<WSCookie>(this.cookies);
    }

    public Optional<BodyWritable> getBody() {
        return Optional.ofNullable(this.bodyWritable);
    }

    public Map<String, List<String>> getHeaders() {
        return new HashMap<String, List<String>>(this.headers);
    }

    public List<String> getHeaderValues(String string) {
        return this.getHeaders().getOrDefault(string, Collections.emptyList());
    }

    public Optional<String> getHeader(String string) {
        return this.getHeaderValues(string).stream().findFirst();
    }

    public Map<String, List<String>> getQueryParameters() {
        return new LinkedHashMap<String, List<String>>(this.queryParameters);
    }

    public Optional<WSAuthInfo> getAuth() {
        return Optional.ofNullable(this.auth);
    }

    public Optional<WSSignatureCalculator> getCalculator() {
        return Optional.ofNullable(this.calculator);
    }

    public Optional<Duration> getRequestTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Optional<Boolean> getFollowRedirects() {
        return Optional.ofNullable(this.followRedirects);
    }

    public Optional<Boolean> getDisableUrlEncoding() {
        return Optional.ofNullable(this.disableUrlEncoding);
    }

    Optional<String> getVirtualHost() {
        return Optional.ofNullable(this.virtualHost);
    }

    public CompletionStage<? extends StandaloneWSResponse> get() {
        return this.execute("GET");
    }

    public CompletionStage<? extends StandaloneWSResponse> patch(BodyWritable bodyWritable) {
        return this.setMethod("PATCH").setBody(bodyWritable).execute();
    }

    public CompletionStage<? extends StandaloneWSResponse> post(BodyWritable bodyWritable) {
        return this.setMethod("POST").setBody(bodyWritable).execute();
    }

    public CompletionStage<? extends StandaloneWSResponse> put(BodyWritable bodyWritable) {
        return this.setMethod("PUT").setBody(bodyWritable).execute();
    }

    public CompletionStage<? extends StandaloneWSResponse> delete() {
        return this.setMethod("DELETE").execute();
    }

    public CompletionStage<? extends StandaloneWSResponse> head() {
        return this.setMethod("HEAD").execute();
    }

    public CompletionStage<? extends StandaloneWSResponse> options() {
        return this.setMethod("OPTIONS").execute();
    }

    public CompletionStage<? extends StandaloneWSResponse> execute(String string) {
        return this.setMethod(string).execute();
    }

    public CompletionStage<? extends StandaloneWSResponse> execute() {
        WSRequestExecutor wSRequestExecutor = this.foldRight(standaloneWSRequest -> {
            StandaloneAhcWSRequest standaloneAhcWSRequest = (StandaloneAhcWSRequest)standaloneWSRequest;
            Request request = standaloneAhcWSRequest.buildRequest();
            return this.client.execute(request);
        }, this.filters.iterator());
        return (CompletionStage)wSRequestExecutor.apply((Object)this);
    }

    public CompletionStage<? extends StandaloneWSResponse> stream() {
        WSRequestExecutor wSRequestExecutor = this.foldRight(standaloneWSRequest -> {
            StandaloneAhcWSRequest standaloneAhcWSRequest = (StandaloneAhcWSRequest)standaloneWSRequest;
            Request request = standaloneAhcWSRequest.buildRequest();
            return this.client.executeStream(request, (ExecutionContext)this.materializer.executionContext());
        }, this.filters.iterator());
        return (CompletionStage)wSRequestExecutor.apply((Object)this);
    }

    private WSRequestExecutor foldRight(WSRequestExecutor wSRequestExecutor, Iterator<WSRequestFilter> iterator) {
        if (!iterator.hasNext()) {
            return wSRequestExecutor;
        }
        WSRequestFilter wSRequestFilter = iterator.next();
        return this.foldRight((WSRequestExecutor)wSRequestFilter.apply((Object)wSRequestExecutor), iterator);
    }

    Request buildRequest() {
        DefaultHttpHeaders defaultHttpHeaders = new DefaultHttpHeaders(true);
        this.headers.forEach((arg_0, arg_1) -> ((HttpHeaders)defaultHttpHeaders).add(arg_0, arg_1));
        RequestBuilder requestBuilder = new RequestBuilder(this.method, this.disableUrlEncoding != null ? this.disableUrlEncoding.booleanValue() : ((AsyncHttpClient)this.client.getUnderlying()).getConfig().isDisableUrlEncodingForBoundRequests());
        requestBuilder.setUrl(this.url);
        requestBuilder.setQueryParams(this.queryParameters);
        this.getBody().ifPresent(arg_0 -> this.lambda$buildRequest$5((HttpHeaders)defaultHttpHeaders, requestBuilder, arg_0));
        requestBuilder.setHeaders((HttpHeaders)defaultHttpHeaders);
        if (this.timeout.isNegative()) {
            requestBuilder.setRequestTimeout((int)INFINITE.toMillis());
        } else if (this.timeout.compareTo(Duration.ZERO) > 0) {
            requestBuilder.setRequestTimeout((int)this.timeout.toMillis());
        }
        this.getFollowRedirects().ifPresent(arg_0 -> ((RequestBuilder)requestBuilder).setFollowRedirect(arg_0));
        this.getVirtualHost().ifPresent(arg_0 -> ((RequestBuilder)requestBuilder).setVirtualHost(arg_0));
        this.getAuth().ifPresent(wSAuthInfo -> requestBuilder.setRealm(StandaloneAhcWSRequest.auth(wSAuthInfo.getUsername(), wSAuthInfo.getPassword(), wSAuthInfo.getScheme())));
        if (this.calculator != null) {
            if (this.calculator instanceof OAuth.OAuthCalculator) {
                OAuthSignatureCalculator oAuthSignatureCalculator = ((OAuth.OAuthCalculator)this.calculator).getCalculator();
                requestBuilder.setSignatureCalculator((SignatureCalculator)oAuthSignatureCalculator);
            } else if (this.calculator instanceof SignatureCalculator) {
                SignatureCalculator signatureCalculator = (SignatureCalculator)this.calculator;
                requestBuilder.setSignatureCalculator(signatureCalculator);
            } else {
                throw new IllegalStateException("Use OAuth.OAuthCalculator");
            }
        }
        this.cookies.forEach(wSCookie -> {
            DefaultCookie defaultCookie = new DefaultCookie(wSCookie.getName(), wSCookie.getValue());
            defaultCookie.setWrap(false);
            defaultCookie.setDomain((String)wSCookie.getDomain().orElse(null));
            defaultCookie.setPath((String)wSCookie.getPath().orElse(null));
            defaultCookie.setMaxAge(wSCookie.getMaxAge().orElse(-1L).longValue());
            defaultCookie.setSecure(wSCookie.isSecure());
            defaultCookie.setHttpOnly(wSCookie.isHttpOnly());
            requestBuilder.addCookie((Cookie)defaultCookie);
        });
        return requestBuilder.build();
    }

    private static void addValueTo(Map<String, List<String>> map, String string, String string3) {
        Optional<String> optional = map.keySet().stream().filter(string2 -> string2.equalsIgnoreCase(string)).findAny();
        if (optional.isPresent()) {
            optional.ifPresent(string2 -> {
                List<String> list;
                List list2 = (List)map.get(string2);
                if (list2 == null) {
                    list = Collections.singletonList(string3);
                } else {
                    list = new ArrayList<String>(list2.size() + 1);
                    list.addAll(list2);
                    list.add(string3);
                }
                map.put((String)string2, list);
            });
        } else {
            map.put(string, Collections.singletonList(string3));
        }
    }

    static Realm auth(String string, String string2, WSAuthScheme wSAuthScheme) {
        Realm.AuthScheme authScheme = Realm.AuthScheme.valueOf((String)wSAuthScheme.name());
        Boolean bl = wSAuthScheme != WSAuthScheme.DIGEST;
        return new Realm.Builder(string, string2).setScheme(authScheme).setUsePreemptiveAuth(bl.booleanValue()).build();
    }

    private /* synthetic */ void lambda$buildRequest$5(HttpHeaders httpHeaders, RequestBuilder requestBuilder, BodyWritable bodyWritable) {
        String string2 = httpHeaders.get(HttpHeaderNames.CONTENT_TYPE.toString());
        if (string2 == null) {
            string2 = bodyWritable.contentType();
        }
        httpHeaders.set(HttpHeaderNames.CONTENT_TYPE.toString(), Collections.singletonList(string2));
        if (bodyWritable instanceof InMemoryBodyWritable) {
            ByteString byteString2 = (ByteString)((InMemoryBodyWritable)bodyWritable).body().get();
            if (string2.equals("application/json")) {
                requestBuilder.setBody(byteString2.toArray());
            } else {
                Charset charset = HttpUtils.extractContentTypeCharsetAttribute((String)string2);
                if (charset == null) {
                    charset = StandardCharsets.UTF_8;
                }
                requestBuilder.setCharset(charset);
                String string3 = byteString2.decodeString(charset);
                if (string2.equals(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString())) {
                    httpHeaders.remove(HttpHeaderNames.CONTENT_LENGTH.toString());
                    Map<String, List<String>> map = FormUrlEncodedParser.parseAsJava(string3, "utf-8");
                    map.forEach((string, list) -> list.forEach(string2 -> requestBuilder.addFormParam(string, string2)));
                } else {
                    requestBuilder.setBody(string3);
                }
            }
        } else if (bodyWritable instanceof SourceBodyWritable) {
            long l = Optional.ofNullable(httpHeaders.get(HttpHeaderNames.CONTENT_LENGTH.toString())).map(Long::valueOf).orElse(-1L);
            httpHeaders.remove(HttpHeaderNames.CONTENT_LENGTH.toString());
            Source source = (Source)((SourceBodyWritable)bodyWritable).body().get();
            Publisher publisher = (Publisher)source.map((Function & Serializable)byteString -> Unpooled.wrappedBuffer((ByteBuffer)byteString.toByteBuffer())).runWith((Graph)Sink.asPublisher((AsPublisher)AsPublisher.WITHOUT_FANOUT), this.materializer);
            requestBuilder.setBody(publisher, l);
        } else {
            throw new IllegalStateException("Unknown body writable: " + bodyWritable);
        }
    }
}

