/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.DefaultKeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.DefaultTrustManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.Protocols$;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ahc.AhcConfigBuilder$;
import play.api.libs.ws.ahc.AhcLoggerFactory;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.shaded.ahc.io.netty.handler.ssl.SslContextBuilder;
import play.shaded.ahc.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.SslEngineFactory;
import play.shaded.ahc.org.asynchttpclient.netty.ssl.JsseSslEngineFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;

public class AhcConfigBuilder {
    public final AhcWSClientConfig play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig;
    private final Function1 addCustomSettings;
    private final DefaultAsyncHttpClientConfig.Builder builder;
    private final Logger logger;
    private final AhcLoggerFactory loggerFactory;

    public static AhcWSClientConfig $lessinit$greater$default$1() {
        return AhcConfigBuilder$.MODULE$.$lessinit$greater$default$1();
    }

    public AhcConfigBuilder(AhcWSClientConfig ahcConfig) {
        this.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig = ahcConfig;
        this.addCustomSettings = (Function1 & Serializable)x -> (DefaultAsyncHttpClientConfig.Builder)Predef$.MODULE$.identity(x);
        this.builder = new DefaultAsyncHttpClientConfig.Builder();
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.loggerFactory = new AhcLoggerFactory(LoggerFactory.getILoggerFactory());
    }

    public Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> addCustomSettings() {
        return this.addCustomSettings;
    }

    public DefaultAsyncHttpClientConfig.Builder builder() {
        return this.builder;
    }

    public Logger logger() {
        return this.logger;
    }

    public AhcLoggerFactory loggerFactory() {
        return this.loggerFactory;
    }

    public DefaultAsyncHttpClientConfig.Builder configure() {
        WSClientConfig config = this.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig.wsClientConfig();
        this.configureWS(this.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig);
        this.configureSSL(config.ssl());
        return (DefaultAsyncHttpClientConfig.Builder)this.addCustomSettings().apply((Object)this.builder());
    }

    public AsyncHttpClientConfig build() {
        return this.configure().build();
    }

    public AhcConfigBuilder modifyUnderlying(Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> modify) {
        return new AhcConfigBuilder(modify, this){
            private final Function1 addCustomSettings;
            private final DefaultAsyncHttpClientConfig.Builder builder;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig);
                this.addCustomSettings = modify$1.compose($outer.addCustomSettings());
                this.builder = $outer.builder();
            }

            public Function1 addCustomSettings() {
                return this.addCustomSettings;
            }

            public DefaultAsyncHttpClientConfig.Builder builder() {
                return this.builder;
            }
        };
    }

    public void configureWS(AhcWSClientConfig ahcConfig) {
        WSClientConfig config = ahcConfig.wsClientConfig();
        this.builder().setConnectTimeout(AhcConfigBuilder.toMillis$1(config.connectionTimeout())).setReadTimeout(AhcConfigBuilder.toMillis$1(config.idleTimeout())).setRequestTimeout(AhcConfigBuilder.toMillis$1(config.requestTimeout())).setFollowRedirect(config.followRedirects()).setUseProxyProperties(config.useProxyProperties()).setCompressionEnforced(config.compressionEnabled());
        config.userAgent().foreach((Function1 & Serializable)x$0 -> this.builder().setUserAgent(x$0));
        this.builder().setMaxConnectionsPerHost(ahcConfig.maxConnectionsPerHost());
        this.builder().setMaxConnections(ahcConfig.maxConnectionsTotal());
        this.builder().setConnectionTtl(AhcConfigBuilder.toMillis$1(ahcConfig.maxConnectionLifetime()));
        this.builder().setPooledConnectionIdleTimeout(AhcConfigBuilder.toMillis$1(ahcConfig.idleConnectionInPoolTimeout()));
        this.builder().setConnectionPoolCleanerPeriod(AhcConfigBuilder.toMillis$1(ahcConfig.connectionPoolCleanerPeriod()));
        this.builder().setMaxRedirects(ahcConfig.maxNumberOfRedirects());
        this.builder().setMaxRequestRetry(ahcConfig.maxRequestRetry());
        this.builder().setDisableUrlEncodingForBoundRequests(ahcConfig.disableUrlEncoding());
        this.builder().setKeepAlive(ahcConfig.keepAlive());
        this.builder().setShutdownQuietPeriod(0);
        this.builder().setShutdownTimeout(0);
        this.builder().setUseLaxCookieEncoder(ahcConfig.useLaxCookieEncoder());
        if (!ahcConfig.useCookieStore()) {
            this.builder().setCookieStore(null);
            return;
        }
    }

    public String[] configureProtocols(String[] existingProtocols, SSLConfigSettings sslConfig) {
        String[] stringArray;
        Option option = sslConfig.enabledProtocols();
        if (option instanceof Some) {
            Seq configuredProtocols = (Seq)((Some)option).value();
            Object object = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
            stringArray = (String[])((IterableOnceOps)configuredProtocols.filter((Function1 & Serializable)elem -> ArrayOps$.MODULE$.contains$extension(object, elem))).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (None$.MODULE$.equals(option)) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])Protocols$.MODULE$.recommendedProtocols());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)elem -> ArrayOps$.MODULE$.contains$extension(object2, elem)));
            stringArray = (String[])ArrayOps$.MODULE$.toArray$extension(object3, ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)option);
        }
        String[] definedProtocols = stringArray;
        return definedProtocols;
    }

    public String[] configureCipherSuites(String[] existingCiphers, SSLConfigSettings sslConfig) {
        String[] stringArray;
        Option option = sslConfig.enabledCipherSuites();
        if (option instanceof Some) {
            Seq configuredCiphers = (Seq)((Some)option).value();
            stringArray = (String[])((IterableOnceOps)configuredCiphers.filter((Function1 & Serializable)_$1 -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])existingCiphers);
                return ArrayOps$.MODULE$.contains$extension(object, _$1);
            })).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (None$.MODULE$.equals(option)) {
            stringArray = existingCiphers;
        } else {
            throw new MatchError((Object)option);
        }
        String[] definedCiphers = stringArray;
        return definedCiphers;
    }

    public void configureSSL(SSLConfigSettings sslConfig) {
        SSLContext sSLContext;
        if (sslConfig.default()) {
            this.logger().info("buildSSLContext: play.ws.ssl.default is true, using default SSLContext");
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = this.buildKeyManagerFactory(sslConfig);
            TrustManagerFactoryWrapper trustManagerFactory = this.buildTrustManagerFactory(sslConfig);
            sSLContext = new ConfigSSLContextBuilder((com.typesafe.sslconfig.util.LoggerFactory)this.loggerFactory(), sslConfig, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = this.configureProtocols(defaultProtocols, sslConfig);
        defaultParams.setProtocols(protocols);
        this.builder().setEnabledProtocols(protocols);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        String[] cipherSuites = this.configureCipherSuites(defaultCiphers, sslConfig);
        defaultParams.setCipherSuites(cipherSuites);
        this.builder().setEnabledCipherSuites(cipherSuites);
        this.builder().setUseInsecureTrustManager(sslConfig.loose().acceptAnyCertificate());
        if (sslConfig.loose().acceptAnyCertificate()) {
            this.builder().setSslContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
            return;
        }
        this.builder().setSslEngineFactory((SslEngineFactory)new JsseSslEngineFactory(sslContext));
    }

    public KeyManagerFactoryWrapper buildKeyManagerFactory(SSLConfigSettings ssl) {
        return new DefaultKeyManagerFactoryWrapper(ssl.keyManagerConfig().algorithm());
    }

    public TrustManagerFactoryWrapper buildTrustManagerFactory(SSLConfigSettings ssl) {
        return new DefaultTrustManagerFactoryWrapper(ssl.trustManagerConfig().algorithm());
    }

    private static final int toMillis$1(Duration duration) {
        if (duration.isFinite()) {
            return (int)duration.toMillis();
        }
        return -1;
    }
}

