/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.Serializable;
import play.api.Configuration;
import play.api.Environment;
import play.api.inject.ApplicationLifecycle;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.WSConfigParser;
import play.api.libs.ws.ahc.AhcConfigBuilder;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfigParser;
import play.api.libs.ws.ahc.OptionalAhcHttpCacheProvider;
import play.api.libs.ws.ahc.cache.AhcHttpCache;
import play.api.libs.ws.ahc.cache.CachingAsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClient;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Singleton
@ScalaSignature(bytes="\u0006\u0005M4A!\u0004\b\u00013!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b1B#\t\u000b5\u0003A\u0011\u0001(\t\u0011i\u0003\u0001R1A\u0005\u0002mCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004c\u0001\u0001\u0006IA\u0018\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019A\u0007\u0001)A\u0005K\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0007B\u00028\u0001A\u0003%1NA\fBgft7\r\u0013;ua\u000ec\u0017.\u001a8u!J|g/\u001b3fe*\u0011q\u0002E\u0001\u0004C\"\u001c'BA\t\u0013\u0003\t98O\u0003\u0002\u0014)\u0005!A.\u001b2t\u0015\t)b#A\u0002ba&T\u0011aF\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u0001Q\"\u0005\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005!A.\u00198h\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\r=\u0013'.Z2u!\r\u0019\u0003FK\u0007\u0002I)\u0011QEJ\u0001\u0007S:TWm\u0019;\u000b\u0003\u001d\nqA[1lCJ$\u0018-\u0003\u0002*I\tA\u0001K]8wS\u0012,'\u000f\u0005\u0002,g5\tAF\u0003\u0002.]\u0005y\u0011m]=oG\"$H\u000f]2mS\u0016tGO\u0003\u00020a\u0005\u0019qN]4\u000b\u0005=\t$B\u0001\u001a\u0017\u0003\u0019\u0019\b.\u00193fI&\u0011A\u0007\f\u0002\u0010\u0003NLhn\u0019%uiB\u001cE.[3oi\u0006YQM\u001c<je>tW.\u001a8u!\t9\u0004(D\u0001\u0015\u0013\tIDCA\u0006F]ZL'o\u001c8nK:$\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u00028y%\u0011Q\b\u0006\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002)\u0005\u0004\b\u000f\\5dCRLwN\u001c'jM\u0016\u001c\u0017p\u00197f!\t\u0001%)D\u0001B\u0015\t)C#\u0003\u0002D\u0003\n!\u0012\t\u001d9mS\u000e\fG/[8o\u0019&4WmY=dY\u0016\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015AC2p]\u000e,(O]3oi*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u000f\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t=\u001bF+\u0016\u000b\u0003!J\u0003\"!\u0015\u0001\u000e\u00039AQ\u0001R\u0003A\u0004\u0015CQ!N\u0003A\u0002YBQAO\u0003A\u0002mBQAP\u0003A\u0002}B#!B,\u0011\u0005\rB\u0016BA-%\u0005\u0019IeN[3di\u0006\u0019q-\u001a;\u0016\u0003)\nab^:DY&,g\u000e^\"p]\u001aLw-F\u0001_!\ty\u0006-D\u0001\u0011\u0013\t\t\u0007C\u0001\bX'\u000ec\u0017.\u001a8u\u0007>tg-[4\u0002\u001f]\u001c8\t\\5f]R\u001cuN\u001c4jO\u0002\n\u0011#\u00195d/N\u001cE.[3oi\u000e{gNZ5h+\u0005)\u0007CA)g\u0013\t9gBA\tBQ\u000e<6k\u00117jK:$8i\u001c8gS\u001e\f!#\u00195d/N\u001cE.[3oi\u000e{gNZ5hA\u0005)\u0012m]=oG\"#H\u000f]\"mS\u0016tGoQ8oM&<W#A6\u0011\u0005-b\u0017BA7-\u0005U\t5/\u001f8d\u0011R$\bo\u00117jK:$8i\u001c8gS\u001e\fa#Y:z]\u000eDE\u000f\u001e9DY&,g\u000e^\"p]\u001aLw\r\t\u0015\u0003\u0001A\u0004\"aI9\n\u0005I$#!C*j]\u001edW\r^8o\u0001")
public class AsyncHttpClientProvider
implements Provider<AsyncHttpClient> {
    private AsyncHttpClient get;
    private final Environment environment;
    private final Configuration configuration;
    private final ApplicationLifecycle applicationLifecycle;
    private final ExecutionContext executionContext;
    private final WSClientConfig wsClientConfig;
    private final AhcWSClientConfig ahcWsClientConfig;
    private final AsyncHttpClientConfig asyncHttpClientConfig;
    private volatile boolean bitmap$0;

    private AsyncHttpClient get$lzycompute() {
        AsyncHttpClientProvider asyncHttpClientProvider = this;
        synchronized (asyncHttpClientProvider) {
            if (!this.bitmap$0) {
                DefaultAsyncHttpClient defaultAsyncHttpClient;
                OptionalAhcHttpCacheProvider cacheProvider = new OptionalAhcHttpCacheProvider(this.environment, this.configuration, this.applicationLifecycle, this.executionContext);
                DefaultAsyncHttpClient client = new DefaultAsyncHttpClient(this.asyncHttpClientConfig());
                Option<AhcHttpCache> option = cacheProvider.get();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AhcHttpCache ahcHttpCache = (AhcHttpCache)some.value();
                    defaultAsyncHttpClient = new CachingAsyncHttpClient((AsyncHttpClient)client, ahcHttpCache);
                } else if (None$.MODULE$.equals(option)) {
                    defaultAsyncHttpClient = client;
                } else {
                    throw new MatchError(option);
                }
                this.get = defaultAsyncHttpClient;
                this.bitmap$0 = true;
            }
        }
        return this.get;
    }

    public AsyncHttpClient get() {
        if (!this.bitmap$0) {
            return this.get$lzycompute();
        }
        return this.get;
    }

    private WSClientConfig wsClientConfig() {
        return this.wsClientConfig;
    }

    private AhcWSClientConfig ahcWsClientConfig() {
        return this.ahcWsClientConfig;
    }

    private AsyncHttpClientConfig asyncHttpClientConfig() {
        return this.asyncHttpClientConfig;
    }

    @Inject
    public AsyncHttpClientProvider(Environment environment, Configuration configuration, ApplicationLifecycle applicationLifecycle, ExecutionContext executionContext) {
        this.environment = environment;
        this.configuration = configuration;
        this.applicationLifecycle = applicationLifecycle;
        this.executionContext = executionContext;
        this.wsClientConfig = new WSConfigParser(configuration.underlying(), environment.classLoader()).parse();
        this.ahcWsClientConfig = new AhcWSClientConfigParser(this.wsClientConfig(), configuration.underlying(), environment.classLoader()).parse();
        this.asyncHttpClientConfig = new AhcConfigBuilder(this.ahcWsClientConfig()).build();
        applicationLifecycle.addStopHook((Function0 & Serializable)() -> {
            this.get().close();
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        });
    }
}

