/*
 * Decompiled with CFR 0.152.
 */
package play.cache.caffeine;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NamedCaffeineCache<K, V>
implements AsyncCache<K, V> {
    private AsyncCache<K, V> cache;
    private String name;

    public NamedCaffeineCache(String string, AsyncCache<K, V> asyncCache) {
        this.cache = asyncCache;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public CompletableFuture<V> getIfPresent(@Nonnull K k) {
        return this.cache.getIfPresent(k);
    }

    @CheckForNull
    public CompletableFuture<V> get(@Nonnull K k, @Nonnull Function<? super K, ? extends V> function) {
        return this.cache.get(k, function);
    }

    @Nonnull
    public CompletableFuture<V> get(@Nonnull K k, @Nonnull BiFunction<? super K, ? super Executor, ? extends CompletableFuture<? extends V>> biFunction) {
        return this.cache.get(k, biFunction);
    }

    @Nonnull
    public CompletableFuture<Map<K, V>> getAll(@Nonnull Iterable<? extends K> iterable, @Nonnull Function<? super Set<? extends K>, ? extends Map<? extends K, ? extends V>> function) {
        return this.cache.getAll(iterable, function);
    }

    @Nonnull
    public CompletableFuture<Map<K, V>> getAll(@Nonnull Iterable<? extends K> iterable, @Nonnull BiFunction<? super Set<? extends K>, ? super Executor, ? extends CompletableFuture<? extends Map<? extends K, ? extends V>>> biFunction) {
        return this.cache.getAll(iterable, biFunction);
    }

    public void put(@Nonnull K k, @Nonnull CompletableFuture<? extends V> completableFuture) {
        this.cache.put(k, completableFuture);
    }

    @Nonnull
    public ConcurrentMap<K, CompletableFuture<V>> asMap() {
        return this.cache.asMap();
    }

    public Cache<K, V> synchronous() {
        return this.cache.synchronous();
    }
}

