/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pekko.actor.ActorSystem;
import play.api.cache.caffeine.DefaultCaffeineExpiry;
import play.cache.caffeine.CaffeineParser;
import play.cache.caffeine.NamedCaffeineCache;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001\u0002\u0007\u000e\u0001YA\u0001\"\b\u0001\u0003\u0006\u0004%IA\b\u0005\tQ\u0001\u0011\t\u0011)A\u0005?!A\u0011\u0006\u0001BC\u0002\u0013%!\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u0003,\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001dq\u0004A1A\u0005\n}Ba\u0001\u0019\u0001!\u0002\u0013\u0001\u0005\"B6\u0001\t\u0003a\u0007\"B<\u0001\t\u0003A\b\"B?\u0001\t\u0003q\b\u0002CA\u0002\u0001\u0011\u0005Q\"!\u0002\u0003)\r\u000bgMZ3j]\u0016\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0015\tqq\"\u0001\u0005dC\u001a4W-\u001b8f\u0015\t\u0001\u0012#A\u0003dC\u000eDWM\u0003\u0002\u0013'\u0005\u0019\u0011\r]5\u000b\u0003Q\tA\u0001\u001d7bs\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u000611m\u001c8gS\u001e,\u0012a\b\t\u0003A\u0019j\u0011!\t\u0006\u0003;\tR!a\t\u0013\u0002\u0011QL\b/Z:bM\u0016T\u0011!J\u0001\u0004G>l\u0017BA\u0014\"\u0005\u0019\u0019uN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013aC1di>\u00148+_:uK6,\u0012a\u000b\t\u0003YUj\u0011!\f\u0006\u0003]=\nQ!Y2u_JT!\u0001M\u0019\u0002\u000bA,7n[8\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0005\u0003m5\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u0006a\u0011m\u0019;peNK8\u000f^3nA\u00051A(\u001b8jiz\"2A\u000f\u001f>!\tY\u0004!D\u0001\u000e\u0011\u0015iR\u00011\u0001 \u0011\u0015IS\u00011\u0001,\u0003!\u0019\u0017m\u00195f\u001b\u0006\u0004X#\u0001!\u0011\t\u0005C%*V\u0007\u0002\u0005*\u00111\tR\u0001\u000bG>t7-\u001e:sK:$(BA#G\u0003\u0011)H/\u001b7\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011J\u0011\u0002\u000e\u0007>t7-\u001e:sK:$X*\u00199\u0011\u0005-\u0013fB\u0001'Q!\ti\u0015$D\u0001O\u0015\tyU#\u0001\u0004=e>|GOP\u0005\u0003#f\ta\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011+\u0007\u0019\u0004-zK\u0007\u0003B,[9\"l\u0011\u0001\u0017\u0006\u0003\u001deS!\u0001E\n\n\u0005mC&A\u0005(b[\u0016$7)\u00194gK&tWmQ1dQ\u0016\u0004\"!\u00180\r\u0001\u0011IqlBA\u0001\u0002\u0003\u0015\t!\u0019\u0002\tIEl\u0017M]6%c\u0005I1-Y2iK6\u000b\u0007\u000fI\t\u0003E\u0016\u0004\"\u0001G2\n\u0005\u0011L\"a\u0002(pi\"Lgn\u001a\t\u00031\u0019L!aZ\r\u0003\u0007\u0005s\u0017\u0010\u0005\u0002^S\u0012I!nBA\u0001\u0002\u0003\u0015\t!\u0019\u0002\tIEl\u0017M]6%e\u0005Aq-\u001a;DC\u000eDW-F\u0002naN$\"A\\;\u0011\t]SvN\u001d\t\u0003;B$Q!\u001d\u0005C\u0002\u0005\u0014\u0011a\u0013\t\u0003;N$Q\u0001\u001e\u0005C\u0002\u0005\u0014\u0011A\u0016\u0005\u0006m\"\u0001\rAS\u0001\nG\u0006\u001c\u0007.\u001a(b[\u0016\fQbZ3u\u0007\u0006\u001c\u0007.\u001a(b[\u0016\u001cH#A=\u0011\u0007i\\(*D\u0001E\u0013\taHIA\u0002TKR\f!bY1dQ\u0016t\u0015-\\3t+\u0005y\b\u0003B&\u0002\u0002)K!\u0001 +\u0002\u001f\u001d,GoQ1dQ\u0016\u0014U/\u001b7eKJ$B!a\u0002\u0002*A2\u0011\u0011BA\u0010\u0003K\u0001\u0002\"a\u0003\u0002\u001a\u0005u\u00111E\u0007\u0003\u0003\u001bQ1\u0001EA\b\u0015\rq\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0005cK:l\u0017M\\3t\u0015\r\t9\u0002J\u0001\u0007O&$\b.\u001e2\n\t\u0005m\u0011Q\u0002\u0002\t\u0007\u00064g-Z5oKB\u0019Q,a\b\u0005\u0015\u0005\u00052\"!A\u0001\u0002\u000b\u0005\u0011M\u0001\u0005%c6\f'o\u001b\u00136!\ri\u0016Q\u0005\u0003\u000b\u0003OY\u0011\u0011!A\u0001\u0006\u0003\t'\u0001\u0003\u0013r[\u0006\u00148\u000e\n\u001c\t\u000bY\\\u0001\u0019\u0001&")
public class CaffeineCacheManager {
    private final Config config;
    private final ActorSystem actorSystem;
    private final ConcurrentMap<String, NamedCaffeineCache<?, ?>> cacheMap;

    private Config config() {
        return this.config;
    }

    private ActorSystem actorSystem() {
        return this.actorSystem;
    }

    private ConcurrentMap<String, NamedCaffeineCache<?, ?>> cacheMap() {
        return this.cacheMap;
    }

    public <K, V> NamedCaffeineCache<K, V> getCache(String cacheName2) {
        return this.cacheMap().computeIfAbsent(cacheName2, cacheName -> {
            Caffeine<?, ?> cacheBuilder = this.getCacheBuilder((String)cacheName);
            NamedCaffeineCache namedCache = new NamedCaffeineCache((String)cacheName, cacheBuilder.buildAsync());
            return namedCache;
        });
    }

    public Set<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap().keySet());
    }

    public scala.collection.immutable.Set<String> cacheNames() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.cacheMap().keySet()).asScala().toSet();
    }

    public Caffeine<?, ?> getCacheBuilder(String cacheName) {
        DefaultCaffeineExpiry defaultExpiry = new DefaultCaffeineExpiry();
        Config caches = this.config().getConfig("caches");
        Config defaults = this.config().getConfig("defaults");
        Config cacheConfig = caches.hasPath(cacheName) ? caches.getConfig(cacheName).withFallback((ConfigMergeable)defaults) : defaults;
        return CaffeineParser.from(cacheConfig, this.actorSystem()).expireAfter((Expiry)defaultExpiry);
    }

    public CaffeineCacheManager(Config config, ActorSystem actorSystem) {
        this.config = config;
        this.actorSystem = actorSystem;
        this.cacheMap = new ConcurrentHashMap(16);
    }
}

