/*
 * Decompiled with CFR 0.152.
 */
package play.cache.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.typesafe.config.Config;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.pekko.actor.ActorSystem;
import play.cache.caffeine.CaffeineExecutionContext;

public final class CaffeineParser {
    private final Caffeine<Object, Object> cacheBuilder = Caffeine.newBuilder();
    private final Config config;
    private final ActorSystem actorSystem;

    private CaffeineParser(Config config, ActorSystem actorSystem) {
        this.config = Objects.requireNonNull(config);
        this.actorSystem = actorSystem;
    }

    public static Caffeine<Object, Object> from(Config config, ActorSystem actorSystem) {
        CaffeineParser caffeineParser = new CaffeineParser(config, actorSystem);
        config.entrySet().stream().map(Map.Entry::getKey).forEach(caffeineParser::parse);
        return caffeineParser.cacheBuilder;
    }

    private void parse(String string) {
        switch (string) {
            case "initial-capacity": {
                if (this.config.getIsNull(string)) break;
                this.cacheBuilder.initialCapacity(this.config.getInt(string));
                break;
            }
            case "maximum-size": {
                if (this.config.getIsNull(string)) break;
                this.cacheBuilder.maximumSize(this.config.getLong(string));
                break;
            }
            case "weak-keys": {
                this.conditionally(string, () -> this.cacheBuilder.weakKeys());
                break;
            }
            case "weak-values": {
                this.conditionally(string, () -> this.cacheBuilder.weakValues());
                break;
            }
            case "soft-values": {
                this.conditionally(string, () -> this.cacheBuilder.softValues());
                break;
            }
            case "record-stats": {
                this.conditionally(string, () -> this.cacheBuilder.recordStats());
                break;
            }
            case "executor": {
                if (this.config.getIsNull(string)) {
                    this.cacheBuilder.executor((Executor)this.actorSystem.dispatcher());
                    break;
                }
                this.cacheBuilder.executor((Executor)((Object)new CaffeineExecutionContext(this.actorSystem, this.config.getString(string))));
                break;
            }
        }
    }

    private void conditionally(String string, Runnable runnable) {
        if (this.config.getBoolean(string)) {
            runnable.run();
        }
    }
}

