/*
 * Decompiled with CFR 0.152.
 */
package play.doc;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import play.doc.FileHandle;
import play.doc.FileHandle$;
import play.doc.FileRepository;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public class FilesystemRepository
implements FileRepository {
    private final File base;

    public FilesystemRepository(File base) {
        this.base = base;
    }

    private <A> A cleanUp(Function1<InputStream, A> loader, InputStream is) {
        Object object;
        try {
            object = loader.apply((Object)is);
        }
        finally {
            is.close();
        }
        return (A)object;
    }

    private Option<File> getFile(String path) {
        File file = new File(this.base, path);
        if (file.exists() && file.isFile() && file.canRead()) {
            return Some$.MODULE$.apply((Object)file);
        }
        return None$.MODULE$;
    }

    @Override
    public <A> Option<A> loadFile(String path, Function1<InputStream, A> loader) {
        return this.getFile(path).map((Function1 & Serializable)file -> {
            FileInputStream is = new FileInputStream((File)file);
            return this.cleanUp(loader, is);
        });
    }

    @Override
    public <A> Option<A> handleFile(String path, Function1<FileHandle, A> handler) {
        return this.getFile(path).map((Function1 & Serializable)file -> {
            FileInputStream is = new FileInputStream((File)file);
            FileHandle handle = FileHandle$.MODULE$.apply(file.getName(), file.length(), is, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> is.close());
            return handler.apply((Object)handle);
        });
    }

    @Override
    public Option<String> findFileWithName(String name) {
        return FilesystemRepository.findFile$1(name, this.base).map((Function1 & Serializable)_$2 -> StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(_$2.getAbsolutePath()), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(this.base.getAbsolutePath())) + 1));
    }

    public String toString() {
        return "FilesystemRepository(" + this.base + ")";
    }

    private static final Option findFile$1$$anonfun$2(String name$2, File dir$1) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])dir$1.listFiles());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$1 -> _$1.isDirectory()));
        return ArrayOps$.MODULE$.collectFirst$extension(object2, Function$.MODULE$.unlift((Function1 & Serializable)dir -> FilesystemRepository.findFile$1(name$2, dir)));
    }

    private static final Option findFile$1(String name, File dir) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])dir.listFiles());
        return ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)file -> file.isFile() && file.getName().equalsIgnoreCase(name)).orElse(() -> FilesystemRepository.findFile$1$$anonfun$2(name, dir));
    }
}

