/*
 * Decompiled with CFR 0.152.
 */
package play.db.ebean;

import io.ebean.Database;
import io.ebean.DatabaseFactory;
import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.dbmigration.model.CurrentModel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.Environment;
import play.api.db.evolutions.DynamicEvolutions;
import play.api.db.evolutions.Evolutions$;
import play.api.db.evolutions.EvolutionsConfig;
import play.db.ebean.EbeanConfig;
import play.inject.ApplicationLifecycle;

@Singleton
public class EbeanDynamicEvolutions
extends DynamicEvolutions {
    private final EbeanConfig config;
    private final Environment environment;
    private final EvolutionsConfig evolutionsConfig;
    private final Map<String, Database> databases = new HashMap<String, Database>();

    @Inject
    public EbeanDynamicEvolutions(EbeanConfig ebeanConfig, Environment environment, ApplicationLifecycle applicationLifecycle, EvolutionsConfig evolutionsConfig) {
        this.config = ebeanConfig;
        this.environment = environment;
        this.evolutionsConfig = evolutionsConfig;
        this.start();
        applicationLifecycle.addStopHook(() -> {
            this.databases.forEach((string, database) -> database.shutdown(false, false));
            return CompletableFuture.completedFuture(null);
        });
    }

    public void start() {
        this.config.serverConfigs().forEach((string, databaseConfig) -> this.databases.put((String)string, DatabaseFactory.create((DatabaseConfig)databaseConfig)));
    }

    public void create() {
        if (this.environment.isProd()) {
            return;
        }
        this.config.serverConfigs().forEach((string, databaseConfig) -> {
            String string2 = EbeanDynamicEvolutions.generateEvolutionScript(this.databases.get(string));
            if (string2 == null) {
                return;
            }
            File file = this.environment.getFile(Evolutions$.MODULE$.fileName(string, 1, this.evolutionsConfig.forDatasource(string).path()));
            try {
                String string3 = "";
                if (file.exists()) {
                    string3 = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                }
                if (string3.isEmpty() || string3.startsWith("# --- Created by Ebean DDL") || string3.startsWith("-- Created by Ebean DDL")) {
                    this.environment.getFile(Evolutions$.MODULE$.directoryName(string, this.evolutionsConfig.forDatasource(string).path())).mkdirs();
                    if (!string3.equals(string2)) {
                        Files.write(file.toPath(), string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        });
    }

    public static String generateEvolutionScript(Database database) {
        return EbeanDynamicEvolutions.generateScript((SpiEbeanServer)database);
    }

    private static String generateScript(SpiEbeanServer spiEbeanServer) {
        CurrentModel currentModel = new CurrentModel(spiEbeanServer);
        String string = currentModel.getCreateDdl();
        String string2 = currentModel.getDropAllDdl();
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        return "-- Created by Ebean DDL\r\n-- To stop Ebean DDL generation, remove this comment (both lines) and start using Evolutions\r\n\r\n-- !Ups\r\n\r\n" + string + "\r\n-- !Downs\r\n\r\n" + string2;
    }
}

