/*
 * Decompiled with CFR 0.152.
 */
package play.dev.filewatch;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.DirectoryWatcher;
import io.methvin.watchservice.MacOSXListeningWatchService;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.WatchService;
import java.util.List;
import play.dev.filewatch.FileWatchService;
import play.dev.filewatch.FileWatcher;
import play.dev.filewatch.LoggerProxy;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public class DefaultFileWatchService
implements FileWatchService {
    private final LoggerProxy logger;
    private final boolean isMac;
    private final boolean disableFileHashCheck;

    public DefaultFileWatchService(LoggerProxy logger, boolean isMac, boolean disableFileHashCheck) {
        this.logger = logger;
        this.isMac = isMac;
        this.disableFileHashCheck = disableFileHashCheck;
    }

    public DefaultFileWatchService(LoggerProxy logger) {
        this(logger, false, false);
    }

    public DefaultFileWatchService(LoggerProxy logger, boolean isMac) {
        this(logger, isMac, false);
    }

    @Override
    public FileWatcher watch(scala.collection.immutable.Seq<File> filesToWatch, Function0<BoxedUnit> onChange) {
        scala.collection.immutable.Seq dirsToWatch = (scala.collection.immutable.Seq)filesToWatch.filter((Function1 & Serializable)file -> {
            if (file.isDirectory()) {
                return true;
            }
            if (file.isFile()) {
                this.logger.warn((Function0<String>)((Function0 & Serializable)() -> DefaultFileWatchService.$anonfun$1$$anonfun$1(file)));
                this.logger.warn((Function0<String>)((Function0 & Serializable)DefaultFileWatchService::$anonfun$1$$anonfun$2));
                return false;
            }
            return false;
        });
        Object watchService = this.isMac ? new MacOSXListeningWatchService() : FileSystems.getDefault().newWatchService();
        DirectoryWatcher directoryWatcher = DirectoryWatcher.builder().paths((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dirsToWatch.map((Function1 & Serializable)_$1 -> _$1.toPath())).asJava()).listener(new DirectoryChangeListener(onChange){
            private final Function0 onChange$1;
            {
                this.onChange$1 = onChange$2;
            }

            public void onEvent(DirectoryChangeEvent event) {
                this.onChange$1.apply$mcV$sp();
            }
        }).fileHashing(!this.disableFileHashCheck).watchService((WatchService)watchService).build();
        Thread thread = new Thread(new Runnable(directoryWatcher){
            private final DirectoryWatcher directoryWatcher$1;
            {
                this.directoryWatcher$1 = directoryWatcher$3;
            }

            public void run() {
                try {
                    this.directoryWatcher$1.watch();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                    }
                    throw throwable;
                }
            }
        }, "play-watch-service");
        thread.setDaemon(true);
        thread.start();
        return new FileWatcher(directoryWatcher){
            private final DirectoryWatcher directoryWatcher$2;
            {
                this.directoryWatcher$2 = directoryWatcher$4;
            }

            public void stop() {
                this.directoryWatcher$2.close();
            }
        };
    }

    private static final String $anonfun$1$$anonfun$1(File file$1) {
        return "An attempt has been made to watch the file: " + file$1.getCanonicalPath();
    }

    private static final String $anonfun$1$$anonfun$2() {
        return "DefaultFileWatchService only supports watching directories. The file will not be watched.";
    }
}

