/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import play.api.MarkerContext$;
import play.api.db.Database;
import play.api.db.evolutions.DatabaseEvolutions$;
import play.api.db.evolutions.DatabaseUrlPatterns$;
import play.api.db.evolutions.DefaultEvolutionsApi$;
import play.api.db.evolutions.DownScript;
import play.api.db.evolutions.Evolution;
import play.api.db.evolutions.Evolutions$;
import play.api.db.evolutions.EvolutionsHelper$;
import play.api.db.evolutions.EvolutionsReader;
import play.api.db.evolutions.InconsistentDatabase;
import play.api.db.evolutions.Script;
import play.api.db.evolutions.UpScript;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001B\u0010!\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\t\u0001B\u0001B\u0003%a\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!1\u0005A!A!\u0002\u00131\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011!\u0003!\u0011!Q\u0001\n%CQ\u0001\u0014\u0001\u0005\u00025CQ\u0001\u0014\u0001\u0005\u0002]CQ\u0001\u0014\u0001\u0005\u0002mCQA\u0018\u0001\u0005\u0002}CQA\u0018\u0001\u0005\u0002EDQa\u001e\u0001\u0005\u0002aDQ!\u001f\u0001\u0005\u0002iDq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0001bBA0\u0001\u0011%\u0011\u0011\r\u0005\n\u0003[\u0002\u0011\u0013!C\u0005\u0003_Bq!!\"\u0001\t\u0013\t9iB\u0005\u0002\u001e\u0002\n\t\u0011#\u0001\u0002 \u001aAq\u0004IA\u0001\u0012\u0003\t\t\u000b\u0003\u0004M/\u0011\u0005\u00111\u0015\u0005\n\u0003K;\u0012\u0013!C\u0001\u0003OC\u0011\"a+\u0018#\u0003%\t!a*\t\u0013\u00055v#%A\u0005\u0002\u0005=\u0006\"CAZ/E\u0005I\u0011AAT\u0011%\t)lFI\u0001\n\u0003\t9\u000bC\u0005\u00028^\t\n\u0011\"\u0001\u0002p\t\u0011B)\u0019;bE\u0006\u001cX-\u0012<pYV$\u0018n\u001c8t\u0015\t\t#%\u0001\u0006fm>dW\u000f^5p]NT!a\t\u0013\u0002\u0005\u0011\u0014'BA\u0013'\u0003\r\t\u0007/\u001b\u0006\u0002O\u0005!\u0001\u000f\\1z\u0007\u0001\u0019\"\u0001\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g\u0003!!\u0017\r^1cCN,\u0007C\u0001\u001a4\u001b\u0005\u0011\u0013B\u0001\u001b#\u0005!!\u0015\r^1cCN,\u0017AB:dQ\u0016l\u0017\r\u0005\u00028}9\u0011\u0001\b\u0010\t\u0003s1j\u0011A\u000f\u0006\u0003w!\na\u0001\u0010:p_Rt\u0014BA\u001f-\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ub\u0013!C7fi\u0006$\u0016M\u00197f\u0003U\u0019XOY:uSR,H/[8og6\u000b\u0007\u000f]5oON\u0004Ba\u000e#7m%\u0011Q\t\u0011\u0002\u0004\u001b\u0006\u0004\u0018aE:vEN$\u0018\u000e^;uS>t7\u000f\u0015:fM&D\u0018aE:vEN$\u0018\u000e^;uS>t7oU;gM&D\u0018aE:vEN$\u0018\u000e^;uS>t7/R:dCB,\u0007CA\u0016K\u0013\tYEFA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)!q\u0005+\u0015*T)V3\u0006CA(\u0001\u001b\u0005\u0001\u0003\"\u0002\u0019\t\u0001\u0004\t\u0004bB\u001b\t!\u0003\u0005\rA\u000e\u0005\b\u0003\"\u0001\n\u00111\u00017\u0011\u001d\u0011\u0005\u0002%AA\u0002\rCqA\u0012\u0005\u0011\u0002\u0003\u0007a\u0007C\u0004H\u0011A\u0005\t\u0019\u0001\u001c\t\u000f!C\u0001\u0013!a\u0001\u0013R!a\nW-[\u0011\u0015\u0001\u0014\u00021\u00012\u0011\u0015)\u0014\u00021\u00017\u0011\u0015\t\u0015\u00021\u00017)\rqE,\u0018\u0005\u0006a)\u0001\r!\r\u0005\u0006k)\u0001\rAN\u0001\bg\u000e\u0014\u0018\u000e\u001d;t)\t\u0001G\u000eE\u0002bM&t!A\u00193\u000f\u0005e\u001a\u0017\"A\u0017\n\u0005\u0015d\u0013a\u00029bG.\fw-Z\u0005\u0003O\"\u00141aU3r\u0015\t)G\u0006\u0005\u0002PU&\u00111\u000e\t\u0002\u0007'\u000e\u0014\u0018\u000e\u001d;\t\u000b\u0005Z\u0001\u0019A7\u0011\u0007\u00054g\u000e\u0005\u0002P_&\u0011\u0001\u000f\t\u0002\n\u000bZ|G.\u001e;j_:$\"\u0001\u0019:\t\u000bMd\u0001\u0019\u0001;\u0002\rI,\u0017\rZ3s!\tyU/\u0003\u0002wA\t\u0001RI^8mkRLwN\\:SK\u0006$WM]\u0001\u0013I\u0006$\u0018MY1tK\u00163x\u000e\\;uS>t7\u000fF\u0001n\u0003\u0019)go\u001c7wKR\u00191P`@\u0011\u0005-b\u0018BA?-\u0005\u0011)f.\u001b;\t\u000bys\u0001\u0019\u00011\t\r\u0005\u0005a\u00021\u0001J\u0003)\tW\u000f^8d_6l\u0017\u000e^\u0001\u0015G\",7m[#w_2,H/[8ogN#\u0018\r^3\u0015\u0003m\fAB]3tKR\u001c6M]5qiN$\u0012\u0001Y\u0001\be\u0016\u001cx\u000e\u001c<f)\rY\u0018q\u0002\u0005\b\u0003#\t\u0002\u0019AA\n\u0003!\u0011XM^5tS>t\u0007cA\u0016\u0002\u0016%\u0019\u0011q\u0003\u0017\u0003\u0007%sG/\u0001\u0007fq\u0016\u001cW\u000f^3Rk\u0016\u0014\u00180\u0006\u0003\u0002\u001e\u0005\u001dB\u0003BA\u0010\u0003;\"B!!\t\u0002NQ!\u00111EA\u001d!\u0011\t)#a\n\r\u0001\u00119\u0011\u0011\u0006\nC\u0002\u0005-\"!\u0001+\u0012\t\u00055\u00121\u0007\t\u0004W\u0005=\u0012bAA\u0019Y\t9aj\u001c;iS:<\u0007cA\u0016\u00026%\u0019\u0011q\u0007\u0017\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002<I\u0001\u001d!!\u0010\u0002\u0003\r\u0004B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0002tc2T!!a\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\n\tE\u0001\u0006D_:tWm\u0019;j_:Dq!a\u0014\u0013\u0001\u0004\t\t&A\u0001g!\u001dY\u00131KA,\u0003GI1!!\u0016-\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002@\u0005e\u0013\u0002BA.\u0003\u0003\u0012\u0011BU3tk2$8+\u001a;\t\r\u0005\r#\u00031\u00017\u0003\u001d)\u00070Z2vi\u0016$b!a\u0019\u0002h\u0005%DcA%\u0002f!9\u00111H\nA\u0004\u0005u\u0002BBA\"'\u0001\u0007a\u0007\u0003\u0005\u0002lM\u0001\n\u00111\u0001J\u0003%iW\r^1Rk\u0016\u0014\u00180A\tfq\u0016\u001cW\u000f^3%I\u00164\u0017-\u001e7uII*\"!!\u001d+\u0007%\u000b\u0019h\u000b\u0002\u0002vA!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014!C;oG\",7m[3e\u0015\r\ty\bL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAB\u0003s\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003E\u0001(/\u001a9be\u0016\fe\u000eZ#yK\u000e,H/\u001a\u000b\u0005\u0003\u0013\u000bY\n\u0006\u0003\u0002\f\u0006=EcA%\u0002\u000e\"9\u00111H\u000bA\u0004\u0005u\u0002bBAI+\u0001\u0007\u00111S\u0001\u0006E2|7m\u001b\t\u0007W\u0005M\u0013QS>\u0011\t\u0005}\u0012qS\u0005\u0005\u00033\u000b\tEA\tQe\u0016\u0004\u0018M]3e'R\fG/Z7f]RDa!a\u0011\u0016\u0001\u00041\u0014A\u0005#bi\u0006\u0014\u0017m]3Fm>dW\u000f^5p]N\u0004\"aT\f\u0014\u0005]QCCAAP\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0016\u0016\u0004m\u0005M\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003cS3aQA:\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:\u0004")
public class DatabaseEvolutions {
    private final Database database;
    private final String schema;
    private final String metaTable;
    private final Map<String, String> substitutionsMappings;
    private final String substitutionsPrefix;
    private final String substitutionsSuffix;
    private final boolean substitutionsEscape;

    public static boolean $lessinit$greater$default$7() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$7();
    }

    public static String $lessinit$greater$default$6() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$5();
    }

    public static Map<String, String> $lessinit$greater$default$4() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return DatabaseEvolutions$.MODULE$.$lessinit$greater$default$2();
    }

    public Seq<Script> scripts(Seq<Evolution> evolutions) {
        if (evolutions.nonEmpty()) {
            Seq application = (Seq)evolutions.reverse();
            Seq<Evolution> database = this.databaseEvolutions();
            Tuple2 tuple2 = database.span((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DatabaseEvolutions.$anonfun$scripts$1(application, e)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq nonConflictingDowns = (Seq)tuple2._1();
            Seq dRest = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)nonConflictingDowns, (Object)dRest);
            Seq nonConflictingDowns2 = (Seq)tuple22._1();
            Seq dRest2 = (Seq)tuple22._2();
            Tuple2 tuple23 = application.span((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DatabaseEvolutions.$anonfun$scripts$3(database, e)));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Seq nonConflictingUps = (Seq)tuple23._1();
            Seq uRest = (Seq)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)nonConflictingUps, (Object)uRest);
            Seq nonConflictingUps2 = (Seq)tuple24._1();
            Seq uRest2 = (Seq)tuple24._2();
            Tuple2<Seq<Evolution>, Seq<Evolution>> tuple25 = Evolutions$.MODULE$.conflictings((Seq<Evolution>)dRest2, (Seq<Evolution>)uRest2);
            if (tuple25 == null) {
                throw new MatchError(tuple25);
            }
            Seq conflictingDowns = (Seq)tuple25._1();
            Seq conflictingUps = (Seq)tuple25._2();
            Tuple2 tuple26 = new Tuple2((Object)conflictingDowns, (Object)conflictingUps);
            Seq conflictingDowns2 = (Seq)tuple26._1();
            Seq conflictingUps2 = (Seq)tuple26._2();
            Seq ups = ((SeqOps)nonConflictingUps2.$plus$plus((IterableOnce)conflictingUps2)).reverseIterator().map((Function1 & Serializable)e -> new UpScript((Evolution)e)).toSeq();
            Seq downs = (Seq)((IterableOps)nonConflictingDowns2.$plus$plus((IterableOnce)conflictingDowns2)).map((Function1 & Serializable)e -> new DownScript((Evolution)e));
            return (Seq)downs.$plus$plus((IterableOnce)ups);
        }
        return Nil$.MODULE$;
    }

    public Seq<Script> scripts(EvolutionsReader reader) {
        return this.scripts((Seq<Evolution>)reader.evolutions(this.database.name()).toList());
    }

    public Seq<Evolution> databaseEvolutions() {
        Seq seq;
        this.checkEvolutionsState();
        try (Connection connection = this.database.getConnection(true);){
            seq = (Seq)this.executeQuery("select id, hash, apply_script, revert_script from ${schema}${evolutions_table} order by id", (Function1 & Serializable)rs2 -> (Seq)((SeqOps)package$.MODULE$.Seq().unfold(rs2, (Function1 & Serializable)rs -> {
                boolean bl = rs.next();
                if (!bl) {
                    return None$.MODULE$;
                }
                if (bl) {
                    return new Some((Object)new Tuple2((Object)new Evolution(rs.getInt(1), (String)Option$.MODULE$.apply((Object)rs.getString(3)).getOrElse((Function0 & Serializable)() -> ""), (String)Option$.MODULE$.apply((Object)rs.getString(4)).getOrElse((Function0 & Serializable)() -> "")), rs));
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            })).reverse(), connection);
        }
        return seq;
    }

    public void evolve(Seq<Script> scripts, boolean autocommit) {
        block10: {
            this.checkEvolutionsState();
            Connection connection = this.database.getConnection(autocommit);
            IntRef applying = IntRef.create((int)-1);
            ObjectRef lastScript = ObjectRef.create(null);
            try {
                Object object;
                try {
                    scripts.foreach((Function1 & Serializable)script -> BoxesRunTime.boxToBoolean((boolean)DatabaseEvolutions.$anonfun$evolve$3(this, lastScript, applying, connection, script)));
                    if (!autocommit) {
                        connection.commit();
                    }
                    object = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        Object object2;
                        Throwable throwable4 = throwable2;
                        if (throwable4 instanceof SQLException) {
                            SQLException sQLException = (SQLException)throwable4;
                            object2 = sQLException.getMessage() + " [ERROR:" + sQLException.getErrorCode() + ", SQLSTATE:" + sQLException.getSQLState() + "]";
                        } else {
                            object2 = throwable4.getMessage();
                        }
                        String message = object2;
                        DefaultEvolutionsApi$.MODULE$.logger().error((Function0 & Serializable)() -> message, MarkerContext$.MODULE$.NoMarker());
                        if (!autocommit) {
                            connection.rollback();
                            String humanScript = "-- Rev:" + ((Script)lastScript.elem).evolution().revision() + "," + ((Script)lastScript.elem instanceof UpScript ? "Ups" : "Downs") + " - " + ((Script)lastScript.elem).evolution().hash() + "\n\n" + ((Script)lastScript.elem instanceof UpScript ? ((Script)lastScript.elem).evolution().sql_up() : ((Script)lastScript.elem).evolution().sql_down());
                            throw new InconsistentDatabase(this.database.name(), humanScript, message, ((Script)lastScript.elem).evolution().revision(), autocommit);
                        }
                        object = BoxesRunTime.boxToBoolean((boolean)this.updateLastProblem$1(message, applying.elem, connection));
                        break block10;
                    }
                    throw throwable;
                }
            }
            finally {
                connection.close();
            }
        }
        this.checkEvolutionsState();
    }

    private void checkEvolutionsState() {
        block7: {
            boolean autocommit = true;
            try (Connection connection = this.database.getConnection(autocommit);){
                try {
                    this.executeQuery("select id, hash, apply_script, revert_script, state, last_problem from ${schema}${evolutions_table} where state like 'applying_%'", (Function1 & Serializable)problem -> {
                        DatabaseEvolutions.$anonfun$checkEvolutionsState$3(this, autocommit, problem);
                        return BoxedUnit.UNIT;
                    }, connection);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InconsistentDatabase) {
                        InconsistentDatabase inconsistentDatabase = (InconsistentDatabase)((Object)throwable2);
                        throw inconsistentDatabase;
                    }
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        this.createPlayEvolutionsTable$1(connection);
                        break block7;
                    }
                    throw throwable;
                }
            }
        }
    }

    public Seq<Script> resetScripts() {
        Seq<Evolution> appliedEvolutions = this.databaseEvolutions();
        return (Seq)appliedEvolutions.map((Function1 & Serializable)evolution -> new DownScript((Evolution)evolution));
    }

    public void resolve(int revision) {
        try (Connection connection = this.database.getConnection(true);){
            this.execute("update ${schema}${evolutions_table} set state = 'applied' where state = 'applying_up' and id = " + revision, this.execute$default$2(), connection);
            this.execute("delete from ${schema}${evolutions_table} where state = 'applying_down' and id = " + revision, this.execute$default$2(), connection);
        }
    }

    private <T> T executeQuery(String sql, Function1<ResultSet, T> f, Connection c) {
        Object object;
        try (Statement ps = c.createStatement();){
            ResultSet rs = ps.executeQuery(EvolutionsHelper$.MODULE$.applySchemaAndTable(sql, this.schema, this.metaTable));
            object = f.apply((Object)rs);
        }
        return (T)object;
    }

    private boolean execute(String sql, boolean metaQuery, Connection c) {
        boolean bl;
        try (Statement s = c.createStatement();){
            bl = s.execute(metaQuery ? EvolutionsHelper$.MODULE$.applySchemaAndTable(sql, this.schema, this.metaTable) : EvolutionsHelper$.MODULE$.substituteVariables(sql, this.substitutionsMappings, this.substitutionsPrefix, this.substitutionsSuffix, this.substitutionsEscape));
        }
        return bl;
    }

    private boolean execute$default$2() {
        return true;
    }

    private boolean prepareAndExecute(String sql, Function1<PreparedStatement, BoxedUnit> block, Connection c) {
        boolean bl;
        try (PreparedStatement ps = c.prepareStatement(EvolutionsHelper$.MODULE$.applySchemaAndTable(sql, this.schema, this.metaTable));){
            block.apply((Object)ps);
            bl = ps.execute();
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$scripts$2(Evolution e$1, Evolution x$1) {
        return e$1.revision() <= x$1.revision();
    }

    public static final /* synthetic */ boolean $anonfun$scripts$1(Seq application$1, Evolution e) {
        return !application$1.headOption().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DatabaseEvolutions.$anonfun$scripts$2(e, x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$scripts$4(Evolution e$2, Evolution x$3) {
        return x$3.revision() >= e$2.revision();
    }

    public static final /* synthetic */ boolean $anonfun$scripts$3(Seq database$1, Evolution e) {
        return !database$1.headOption().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DatabaseEvolutions.$anonfun$scripts$4(e, x$3)));
    }

    public static final /* synthetic */ void $anonfun$evolve$1(Evolution e$3, PreparedStatement ps) {
        ps.setInt(1, e$3.revision());
        ps.setString(2, e$3.hash());
        ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
        ps.setString(4, e$3.sql_up());
        ps.setString(5, e$3.sql_down());
        ps.setString(6, "applying_up");
        ps.setString(7, "");
    }

    private final void logBefore$1(Script script, Connection conn) {
        Script script2 = script;
        if (script2 instanceof UpScript) {
            UpScript upScript = (UpScript)script2;
            Evolution e = upScript.evolution();
            this.prepareAndExecute("insert into ${schema}${evolutions_table} (id, hash, applied_at, apply_script, revert_script, state, last_problem) values(?, ?, ?, ?, ?, ?, ?)", (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)ps -> {
                DatabaseEvolutions.$anonfun$evolve$1(e, ps);
                return BoxedUnit.UNIT;
            }, conn);
            return;
        }
        if (script2 instanceof DownScript) {
            DownScript downScript = (DownScript)script2;
            Evolution e = downScript.evolution();
            this.execute("update ${schema}${evolutions_table} set state = 'applying_down' where id = " + e.revision(), this.execute$default$2(), conn);
            return;
        }
        throw new MatchError((Object)script2);
    }

    private final boolean logAfter$1(Script script, Connection conn) {
        Script script2 = script;
        if (script2 instanceof UpScript) {
            UpScript upScript = (UpScript)script2;
            Evolution e = upScript.evolution();
            return this.execute("update ${schema}${evolutions_table} set state = 'applied' where id = " + e.revision(), this.execute$default$2(), conn);
        }
        if (script2 instanceof DownScript) {
            DownScript downScript = (DownScript)script2;
            Evolution e = downScript.evolution();
            return this.execute("delete from ${schema}${evolutions_table} where id = " + e.revision(), this.execute$default$2(), conn);
        }
        throw new MatchError((Object)script2);
    }

    public static final /* synthetic */ void $anonfun$evolve$2(String message$1, int revision$1, PreparedStatement ps) {
        ps.setString(1, message$1);
        ps.setInt(2, revision$1);
    }

    private final boolean updateLastProblem$1(String message, int revision, Connection conn) {
        return this.prepareAndExecute("update ${schema}${evolutions_table} set last_problem = ? where id = ?", (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)ps -> {
            DatabaseEvolutions.$anonfun$evolve$2(message, revision, ps);
            return BoxedUnit.UNIT;
        }, conn);
    }

    public static final /* synthetic */ void $anonfun$evolve$4(DatabaseEvolutions $this, Connection connection$1, String statement) {
        DefaultEvolutionsApi$.MODULE$.logger().debug((Function0 & Serializable)() -> "Execute: " + statement, MarkerContext$.MODULE$.NoMarker());
        long start = System.currentTimeMillis();
        $this.execute(statement, false, connection$1);
        DefaultEvolutionsApi$.MODULE$.logger().debug((Function0 & Serializable)() -> "Finished in " + (System.currentTimeMillis() - start) + "ms", MarkerContext$.MODULE$.NoMarker());
    }

    public static final /* synthetic */ boolean $anonfun$evolve$3(DatabaseEvolutions $this, ObjectRef lastScript$1, IntRef applying$1, Connection connection$1, Script script) {
        lastScript$1.elem = script;
        applying$1.elem = script.evolution().revision();
        $this.logBefore$1(script, connection$1);
        script.statements().foreach((Function1 & Serializable)statement -> {
            DatabaseEvolutions.$anonfun$evolve$4($this, connection$1, statement);
            return BoxedUnit.UNIT;
        });
        return $this.logAfter$1(script, connection$1);
    }

    private final void createPlayEvolutionsTable$1(Connection conn) {
        try {
            Option option;
            Option option2;
            Option option3;
            Option option4;
            Option option5;
            String string = this.database.url();
            String createScript = string != null && !(option5 = DatabaseUrlPatterns$.MODULE$.SqlServerJdbcUrl().unapplySeq((CharSequence)string)).isEmpty() && option5.get() != null && ((List)option5.get()).lengthCompare(0) == 0 ? DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsSqlServerSql() : (string != null && !(option4 = DatabaseUrlPatterns$.MODULE$.OracleJdbcUrl().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(0) == 0 ? DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsOracleSql() : (string != null && !(option3 = DatabaseUrlPatterns$.MODULE$.MysqlJdbcUrl().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(2) == 0 ? DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsMySql() : (string != null && !(option2 = DatabaseUrlPatterns$.MODULE$.DerbyJdbcUrl().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(0) == 0 ? DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsDerby() : (string != null && !(option = DatabaseUrlPatterns$.MODULE$.HsqlJdbcUrl().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(0) == 0 ? DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsHsql() : DefaultEvolutionsApi$.MODULE$.CreatePlayEvolutionsSql()))));
            this.execute(createScript, this.execute$default$2(), conn);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                DefaultEvolutionsApi$.MODULE$.logger().warn((Function0 & Serializable)() -> EvolutionsHelper$.MODULE$.applySchemaAndTable("could not create ${schema}${evolutions_table} table", $this.schema, $this.metaTable), (Function0 & Serializable)() -> throwable2, MarkerContext$.MODULE$.NoMarker());
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$checkEvolutionsState$3(DatabaseEvolutions $this, boolean autocommit$2, ResultSet problem) {
        block3: {
            String string;
            String hash;
            String state;
            int revision;
            block4: {
                if (!problem.next()) break block3;
                revision = problem.getInt("id");
                state = problem.getString("state");
                hash = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(problem.getString("hash")), 7);
                String string2 = state;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1242173178: {
                        if (!"applying_up".equals(string2)) break;
                        string = problem.getString("apply_script");
                        break block4;
                    }
                }
                string = problem.getString("revert_script");
            }
            String script = string;
            String error = problem.getString("last_problem");
            DefaultEvolutionsApi$.MODULE$.logger().error((Function0 & Serializable)() -> error, MarkerContext$.MODULE$.NoMarker());
            String string3 = state;
            String string4 = "applying_up";
            String humanScript = "-- Rev:" + revision + "," + (!(string3 != null ? !string3.equals(string4) : string4 != null) ? "Ups" : "Downs") + " - " + hash + "\n\n" + script;
            throw new InconsistentDatabase($this.database.name(), humanScript, error, revision, autocommit$2);
        }
    }

    public DatabaseEvolutions(Database database, String schema, String metaTable, Map<String, String> substitutionsMappings, String substitutionsPrefix, String substitutionsSuffix, boolean substitutionsEscape) {
        this.database = database;
        this.schema = schema;
        this.metaTable = metaTable;
        this.substitutionsMappings = substitutionsMappings;
        this.substitutionsPrefix = substitutionsPrefix;
        this.substitutionsSuffix = substitutionsSuffix;
        this.substitutionsEscape = substitutionsEscape;
    }

    public DatabaseEvolutions(Database database, String schema, String metaTable) {
        this(database, schema, metaTable, (Map<String, String>)Predef$.MODULE$.Map().empty(), "$evolutions{{{", "}}}", true);
    }

    public DatabaseEvolutions(Database database, String schema) {
        this(database, schema, "play_evolutions");
    }
}

