/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import com.typesafe.config.ConfigValue;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.Serializable;
import play.api.ConfigLoader;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger;
import play.api.Logger$;
import play.api.db.evolutions.DefaultEvolutionsConfig;
import play.api.db.evolutions.DefaultEvolutionsDatasourceConfig;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Singleton
@ScalaSignature(bytes="\u0006\u0005]3A\u0001C\u0005\u0001%!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u00045\u0001\t\u0007I\u0011B\u001b\t\re\u0002\u0001\u0015!\u00037\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u0015a\u0004\u0001\"\u0001<\u0011\u0015i\u0004\u0001\"\u0001?\u0005u!UMZ1vYR,eo\u001c7vi&|gn]\"p]\u001aLw\rU1sg\u0016\u0014(B\u0001\u0006\f\u0003))go\u001c7vi&|gn\u001d\u0006\u0003\u00195\t!\u0001\u001a2\u000b\u00059y\u0011aA1qS*\t\u0001#\u0001\u0003qY\u0006L8\u0001A\n\u0004\u0001MY\u0002C\u0001\u000b\u001a\u001b\u0005)\"B\u0001\f\u0018\u0003\u0011a\u0017M\\4\u000b\u0003a\tAA[1wC&\u0011!$\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007q\t3%D\u0001\u001e\u0015\tqr$\u0001\u0004j]*,7\r\u001e\u0006\u0002A\u00059!.Y6beR\f\u0017B\u0001\u0012\u001e\u0005!\u0001&o\u001c<jI\u0016\u0014\bC\u0001\u0013&\u001b\u0005I\u0011B\u0001\u0014\n\u0005A)eo\u001c7vi&|gn]\"p]\u001aLw-\u0001\u0006s_>$8i\u001c8gS\u001e\u0004\"!\u000b\u0016\u000e\u00035I!aK\u0007\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0011af\f\t\u0003I\u0001AQa\n\u0002A\u0002!B#AA\u0019\u0011\u0005q\u0011\u0014BA\u001a\u001e\u0005\u0019IeN[3di\u00061An\\4hKJ,\u0012A\u000e\t\u0003S]J!\u0001O\u0007\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n1aZ3u)\u0005\u0019\u0013!\u00029beN,\u0017aC3oC\ndW\rZ&fsN$2aP(R!\r\u0001\u0015\n\u0014\b\u0003\u0003\u001e\u0003\"AQ#\u000e\u0003\rS!\u0001R\t\u0002\rq\u0012xn\u001c;?\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0004'\u0016$(B\u0001%F!\t\u0001U*\u0003\u0002O\u0017\n11\u000b\u001e:j]\u001eDQ\u0001U\u0004A\u0002!\nQbY8oM&<WO]1uS>t\u0007\"\u0002*\b\u0001\u0004a\u0015aB:fGRLwN\u001c\u0015\u0003\u0001Q\u0003\"\u0001H+\n\u0005Yk\"!C*j]\u001edW\r^8o\u0001")
public class DefaultEvolutionsConfigParser
implements Provider<EvolutionsConfig> {
    private final Configuration rootConfig;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public EvolutionsConfig get() {
        return this.parse();
    }

    public EvolutionsConfig parse() {
        Configuration config = (Configuration)this.rootConfig.get("play.evolutions", ConfigLoader$.MODULE$.configurationLoader());
        Set datasources = (Set)((Configuration)config.get("db", ConfigLoader$.MODULE$.configurationLoader())).subKeys().$plus$plus((IterableOnce)this.loadDatasources$1("applyEvolutions")).$plus$plus((IterableOnce)this.loadDatasources$1("applyDownEvolutions"));
        boolean enabled = BoxesRunTime.unboxToBoolean((Object)config.get("enabled", ConfigLoader$.MODULE$.booleanLoader()));
        String schema = (String)config.get("schema", ConfigLoader$.MODULE$.stringLoader());
        String metaTable = (String)config.get("metaTable", ConfigLoader$.MODULE$.stringLoader());
        boolean autocommit = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(config, (Function0 & Serializable)() -> "play.evolutions", "autocommit", "evolutions.autocommit", ConfigLoader$.MODULE$.booleanLoader()));
        boolean useLocks = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(config, (Function0 & Serializable)() -> "play.evolutions", "useLocks", "evolutions.use.locks", ConfigLoader$.MODULE$.booleanLoader()));
        boolean autoApply = BoxesRunTime.unboxToBoolean((Object)config.get("autoApply", ConfigLoader$.MODULE$.booleanLoader()));
        boolean autoApplyDowns = BoxesRunTime.unboxToBoolean((Object)config.get("autoApplyDowns", ConfigLoader$.MODULE$.booleanLoader()));
        boolean skipApplyDownsOnly = BoxesRunTime.unboxToBoolean((Object)config.get("skipApplyDownsOnly", ConfigLoader$.MODULE$.booleanLoader()));
        String path = (String)config.get("path", ConfigLoader$.MODULE$.stringLoader());
        String substPrefix = (String)config.get("substitutions.prefix", ConfigLoader$.MODULE$.stringLoader());
        String substSuffix = (String)config.get("substitutions.suffix", ConfigLoader$.MODULE$.stringLoader());
        Map substMappings = DefaultEvolutionsConfigParser.loadSubstitutionsMappings$1(config);
        boolean escapeEnabled = BoxesRunTime.unboxToBoolean((Object)config.get("substitutions.escapeEnabled", ConfigLoader$.MODULE$.booleanLoader()));
        DefaultEvolutionsDatasourceConfig defaultConfig = new DefaultEvolutionsDatasourceConfig(enabled, schema, metaTable, autocommit, useLocks, autoApply, autoApplyDowns, skipApplyDownsOnly, substPrefix, substSuffix, (Map<String, String>)substMappings, escapeEnabled, path);
        Map datasourceConfigMap = (Map)((IterableOnceOps)datasources.map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)config))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)config.getPrototypedMap("db", ""));
        Map datasourceConfig = (Map)datasourceConfigMap.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String datasource = (String)tuple2._1();
                Configuration dsConfig = (Configuration)tuple2._2();
                boolean enabled = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("enabled", ConfigLoader$.MODULE$.booleanLoader()));
                String schema = (String)dsConfig.get("schema", ConfigLoader$.MODULE$.stringLoader());
                String metaTable = (String)dsConfig.get("metaTable", ConfigLoader$.MODULE$.stringLoader());
                boolean autocommit = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("autocommit", ConfigLoader$.MODULE$.booleanLoader()));
                boolean useLocks = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("useLocks", ConfigLoader$.MODULE$.booleanLoader()));
                boolean autoApply = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(dsConfig, (Function0 & Serializable)() -> "play.evolutions.db." + datasource, "autoApply", "applyEvolutions." + datasource, ConfigLoader$.MODULE$.booleanLoader()));
                boolean autoApplyDowns = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(dsConfig, (Function0 & Serializable)() -> "play.evolutions.db." + datasource, "autoApplyDowns", "applyDownEvolutions." + datasource, ConfigLoader$.MODULE$.booleanLoader()));
                boolean skipApplyDownsOnly = BoxesRunTime.unboxToBoolean((Object)this.getDeprecated$1(dsConfig, (Function0 & Serializable)() -> "play.evolutions.db." + datasource, "skipApplyDownsOnly", "skipApplyDownsOnly." + datasource, ConfigLoader$.MODULE$.booleanLoader()));
                String path = (String)dsConfig.get("path", ConfigLoader$.MODULE$.stringLoader());
                String substPrefix = (String)dsConfig.get("substitutions.prefix", ConfigLoader$.MODULE$.stringLoader());
                String substSuffix = (String)dsConfig.get("substitutions.suffix", ConfigLoader$.MODULE$.stringLoader());
                boolean escapeEnabled = BoxesRunTime.unboxToBoolean((Object)dsConfig.get("substitutions.escapeEnabled", ConfigLoader$.MODULE$.booleanLoader()));
                Map substMappings = DefaultEvolutionsConfigParser.loadSubstitutionsMappings$1(dsConfig);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)datasource), (Object)new DefaultEvolutionsDatasourceConfig(enabled, schema, metaTable, autocommit, useLocks, autoApply, autoApplyDowns, skipApplyDownsOnly, substPrefix, substSuffix, (Map<String, String>)substMappings, escapeEnabled, path));
            }
            throw new MatchError((Object)tuple2);
        });
        return new DefaultEvolutionsConfig(defaultConfig, (Map<String, EvolutionsDatasourceConfig>)datasourceConfig);
    }

    public Set<String> enabledKeys(Configuration configuration, String section) {
        return (Set)configuration.getOptional(section, ConfigLoader$.MODULE$.configurationLoader()).fold((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable)conf -> (Set)conf.keys().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DefaultEvolutionsConfigParser.$anonfun$enabledKeys$3(conf, x$6))));
    }

    private final Object getDeprecated$1(Configuration config, Function0 baseKey, String path, String deprecated, ConfigLoader evidence$1) {
        if (this.rootConfig.underlying().hasPath(deprecated)) {
            this.rootConfig.reportDeprecation(baseKey.apply() + "." + path, deprecated);
            return this.rootConfig.get(deprecated, evidence$1);
        }
        return config.get(path, evidence$1);
    }

    private static final Map loadSubstitutionsMappings$1(Configuration config) {
        return ((IterableOnceOps)((Configuration)config.get("substitutions.mappings", ConfigLoader$.MODULE$.configurationLoader())).entrySet().map((Function1 & Serializable)e -> new Tuple2(e._1(), (Object)((ConfigValue)e._2()).unwrapped().toString()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final Set loadDatasources$1(String path) {
        if (this.rootConfig.underlying().hasPath(path)) {
            return ((Configuration)this.rootConfig.get(path, ConfigLoader$.MODULE$.configurationLoader())).subKeys();
        }
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ boolean $anonfun$enabledKeys$3(Configuration conf$1, String x$6) {
        return BoxesRunTime.unboxToBoolean((Object)conf$1.getOptional(x$6, ConfigLoader$.MODULE$.booleanLoader()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    @Inject
    public DefaultEvolutionsConfigParser(Configuration rootConfig) {
        this.rootConfig = rootConfig;
        this.logger = Logger$.MODULE$.apply(DefaultEvolutionsConfigParser.class);
    }
}

