/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import play.api.Environment;
import play.api.MarkerContext$;
import play.api.db.evolutions.DefaultEvolutionsApi$;
import play.api.db.evolutions.DefaultEvolutionsDatasourceConfig;
import play.api.db.evolutions.Evolutions$;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import play.api.db.evolutions.ResourceEvolutionsReader;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0005a3Aa\u0002\u0005\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0011\u0015y\u0002\u0001\"\u0001!\u0011\u0015y\u0002\u0001\"\u0001.\u0011\u0015y\u0002\u0001\"\u0001?\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0005m)eN^5s_:lWM\u001c;Fm>dW\u000f^5p]N\u0014V-\u00193fe*\u0011\u0011BC\u0001\u000bKZ|G.\u001e;j_:\u001c(BA\u0006\r\u0003\t!'M\u0003\u0002\u000e\u001d\u0005\u0019\u0011\r]5\u000b\u0003=\tA\u0001\u001d7bs\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\t\u0013\t)\u0002B\u0001\rSKN|WO]2f\u000bZ|G.\u001e;j_:\u001c(+Z1eKJ\f1\"\u001a8wSJ|g.\\3oiB\u0011\u0001$G\u0007\u0002\u0019%\u0011!\u0004\u0004\u0002\f\u000b:4\u0018N]8o[\u0016tG/\u0001\tfm>dW\u000f^5p]N\u001cuN\u001c4jOB\u00111#H\u0005\u0003=!\u0011\u0001#\u0012<pYV$\u0018n\u001c8t\u0007>tg-[4\u0002\rqJg.\u001b;?)\r\t#e\t\t\u0003'\u0001AQAF\u0002A\u0002]AQaG\u0002A\u0002qA#aA\u0013\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013AB5oU\u0016\u001cGOC\u0001+\u0003\u001dQ\u0017m[1si\u0006L!\u0001L\u0014\u0003\r%s'.Z2u)\r\tcf\f\u0005\u0006-\u0011\u0001\ra\u0006\u0005\u0006a\u0011\u0001\r!M\u0001\u0005a\u0006$\b\u000e\u0005\u00023w9\u00111'\u000f\t\u0003i]j\u0011!\u000e\u0006\u0003mA\ta\u0001\u0010:p_Rt$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:\u0014A\u0002)sK\u0012,g-\u0003\u0002={\t11\u000b\u001e:j]\u001eT!AO\u001c\u0015\u0005\u0005z\u0004\"\u0002\f\u0006\u0001\u00049\u0012\u0001\u00047pC\u0012\u0014Vm]8ve\u000e,Gc\u0001\"O\u001fB\u00191\t\u0012$\u000e\u0003]J!!R\u001c\u0003\r=\u0003H/[8o!\t9E*D\u0001I\u0015\tI%*\u0001\u0002j_*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000b-1\u0001\u0019A\u0019\t\u000bA3\u0001\u0019A)\u0002\u0011I,g/[:j_:\u0004\"a\u0011*\n\u0005M;$aA%oi\"\u0012\u0001!\u0016\t\u0003MYK!aV\u0014\u0003\u0013MKgn\u001a7fi>t\u0007")
public class EnvironmentEvolutionsReader
extends ResourceEvolutionsReader {
    private final Environment environment;
    private final EvolutionsConfig evolutionsConfig;

    @Override
    public Option<InputStream> loadResource(String db, int revision) {
        return this.findPaddedRevisionResource$1(Integer.toString(revision), (Option)None$.MODULE$, db);
    }

    public static final /* synthetic */ Option $anonfun$loadResource$5(EnvironmentEvolutionsReader $this, String db$2, String paddedRevision$1) {
        String resourceName = Evolutions$.MODULE$.resourceName(db$2, paddedRevision$1, $this.evolutionsConfig.forDatasource(db$2).path());
        return $this.environment.resource(resourceName).map((Function1 & Serializable)url -> url.toURI());
    }

    public static final /* synthetic */ void $anonfun$loadResource$8(URI u$1, URI e) {
        String original = e.toString().substring(e.toString().lastIndexOf(47) + 1);
        String substitute = u$1.toString().substring(u$1.toString().lastIndexOf(47) + 1);
        DefaultEvolutionsApi$.MODULE$.logger().warn((Function0 & Serializable)() -> "Ignoring evolution script " + original + ", using " + substitute + " instead already", MarkerContext$.MODULE$.NoMarker());
    }

    private final Option findPaddedRevisionResource$1(String paddedRevision, Option uri, String db$2) {
        while (((String)paddedRevision).length() <= 15) {
            String filename = Evolutions$.MODULE$.fileName(db$2, (String)paddedRevision, this.evolutionsConfig.forDatasource(db$2).path());
            Path path = Path.of(filename, new String[0]);
            Option evolution = (path.isAbsolute() ? new Some((Object)path.toFile()).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.exists())).map((Function1 & Serializable)x$12 -> x$12.toURI()) : this.environment.getExistingFile(filename).map((Function1 & Serializable)x$13 -> x$13.toURI())).orElse(() -> EnvironmentEvolutionsReader.$anonfun$loadResource$5(this, db$2, (String)paddedRevision));
            uri.foreach((Function1 & Serializable)u -> {
                evolution.foreach((Function1 & Serializable)e -> {
                    EnvironmentEvolutionsReader.$anonfun$loadResource$8(u, e);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            uri = uri.orElse((Function0 & Serializable)() -> evolution);
            paddedRevision = "0" + (String)paddedRevision;
        }
        return uri.map((Function1 & Serializable)u -> u.toURL().openStream());
    }

    @Inject
    public EnvironmentEvolutionsReader(Environment environment, EvolutionsConfig evolutionsConfig) {
        this.environment = environment;
        this.evolutionsConfig = evolutionsConfig;
    }

    public EnvironmentEvolutionsReader(Environment environment, String path) {
        this(environment, new EvolutionsConfig(path){
            private final String path$1;

            public EvolutionsDatasourceConfig forDatasource(String db) {
                return new DefaultEvolutionsDatasourceConfig(true, "", "play_evolutions", true, false, false, false, false, "$evolutions{{{", "}}}", (Map<String, String>)Predef$.MODULE$.Map().empty(), true, this.path$1);
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    public EnvironmentEvolutionsReader(Environment environment) {
        this(environment, "evolutions");
    }
}

