/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.Serializable;
import play.api.db.DBApi;
import play.api.db.evolutions.ApplicationEvolutions$;
import play.api.db.evolutions.Evolutions$;
import play.api.db.evolutions.EvolutionsApi;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import play.api.db.evolutions.EvolutionsReader;
import play.api.db.evolutions.InvalidDatabaseRevision;
import play.api.db.evolutions.Script;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.BuildLink;
import play.core.HandleWebCommandSupport;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

@Singleton
@ScalaSignature(bytes="\u0006\u0005I4AAC\u0006\u0001)!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005\r\u0001\t\u0005\t\u0015!\u0003'\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000bI\u0002A\u0011A\u001a\t\u000f\t\u0003\u0001\u0019!C\u0001\u0007\"9q\t\u0001a\u0001\n\u0003A\u0005B\u0002(\u0001A\u0003&A\tC\u0003P\u0001\u0011\u0005\u0001KA\u000bFm>dW\u000f^5p]N<VMY\"p[6\fg\u000eZ:\u000b\u00051i\u0011AC3w_2,H/[8og*\u0011abD\u0001\u0003I\nT!\u0001E\t\u0002\u0007\u0005\u0004\u0018NC\u0001\u0013\u0003\u0011\u0001H.Y=\u0004\u0001M\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\tar$D\u0001\u001e\u0015\tq\u0012#\u0001\u0003d_J,\u0017B\u0001\u0011\u001e\u0005]A\u0015M\u001c3mK^+'mQ8n[\u0006tGmU;qa>\u0014H/A\u0003eE\u0006\u0003\u0018\u000e\u0005\u0002$I5\tQ\"\u0003\u0002&\u001b\t)AIQ!qSB\u0011q\u0005K\u0007\u0002\u0017%\u0011\u0011f\u0003\u0002\u000e\u000bZ|G.\u001e;j_:\u001c\u0018\t]5\u0002\rI,\u0017\rZ3s!\t9C&\u0003\u0002.\u0017\t\u0001RI^8mkRLwN\\:SK\u0006$WM]\u0001\u0007G>tg-[4\u0011\u0005\u001d\u0002\u0014BA\u0019\f\u0005A)eo\u001c7vi&|gn]\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0006iU2t\u0007\u000f\t\u0003O\u0001AQ!I\u0003A\u0002\tBQ\u0001D\u0003A\u0002\u0019BQAK\u0003A\u0002-BQAL\u0003A\u0002=B#!\u0002\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014AB5oU\u0016\u001cGOC\u0001@\u0003\u001dQ\u0017m[1si\u0006L!!\u0011\u001f\u0003\r%s'.Z2u\u00039\u0019\u0007.Z2lK\u0012\fEN]3bIf,\u0012\u0001\u0012\t\u0003-\u0015K!AR\f\u0003\u000f\t{w\u000e\\3b]\u0006\u00112\r[3dW\u0016$\u0017\t\u001c:fC\u0012Lx\fJ3r)\tIE\n\u0005\u0002\u0017\u0015&\u00111j\u0006\u0002\u0005+:LG\u000fC\u0004N\u000f\u0005\u0005\t\u0019\u0001#\u0002\u0007a$\u0013'A\bdQ\u0016\u001c7.\u001a3BYJ,\u0017\rZ=!\u0003AA\u0017M\u001c3mK^+'mQ8n[\u0006tG\r\u0006\u0003R5~#\u0007c\u0001\fS)&\u00111k\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005UCV\"\u0001,\u000b\u0005]{\u0011aA7wG&\u0011\u0011L\u0016\u0002\u0007%\u0016\u001cX\u000f\u001c;\t\u000bmK\u0001\u0019\u0001/\u0002\u000fI,\u0017/^3tiB\u0011Q+X\u0005\u0003=Z\u0013QBU3rk\u0016\u001cH\u000fS3bI\u0016\u0014\b\"\u00021\n\u0001\u0004\t\u0017!\u00032vS2$G*\u001b8l!\ta\"-\u0003\u0002d;\tI!)^5mI2Kgn\u001b\u0005\u0006K&\u0001\rAZ\u0001\u0005a\u0006$\b\u000e\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006\u0011\u0011n\u001c\u0006\u0002W\u0006!!.\u0019<b\u0013\ti\u0007N\u0001\u0003GS2,\u0007F\u0001\u0001p!\tY\u0004/\u0003\u0002ry\tI1+\u001b8hY\u0016$xN\u001c")
public class EvolutionsWebCommands
implements HandleWebCommandSupport {
    private final DBApi dbApi;
    private final EvolutionsApi evolutions;
    private final EvolutionsReader reader;
    private final EvolutionsConfig config;
    private boolean checkedAlready;

    public boolean checkedAlready() {
        return this.checkedAlready;
    }

    public void checkedAlready_$eq(boolean x$1) {
        this.checkedAlready = x$1;
    }

    public Option<Result> handleWebCommand(RequestHeader request, BuildLink buildLink, File path) {
        Option option;
        Option option2;
        LazyRef redirectUrl$lzy = new LazyRef();
        Regex applyEvolutions = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("/@evolutions/apply/([a-zA-Z0-9_-]+)"));
        Regex resolveEvolutions = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("/@evolutions/resolve/([a-zA-Z0-9_-]+)/([0-9]+)"));
        String string = request.path().replaceFirst("^((?!/@evolutions).)*(/@evolutions.*$)", "$2");
        if (string != null && !(option2 = applyEvolutions.unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String db = (String)((LinearSeqOps)option2.get()).apply(0);
            EvolutionsDatasourceConfig dbConfig = this.config.forDatasource(db);
            Seq<Script> scripts = this.evolutions.scripts(db, this.reader, dbConfig.schema(), dbConfig.metaTable());
            this.evolutions.evolve(db, scripts, dbConfig.autocommit(), dbConfig.schema(), dbConfig.metaTable(), dbConfig.substitutionsMappings(), dbConfig.substitutionsPrefix(), dbConfig.substitutionsSuffix(), dbConfig.substitutionsEscape());
            buildLink.forceReload();
            return new Some((Object)Results$.MODULE$.Redirect(EvolutionsWebCommands.redirectUrl$1(redirectUrl$lzy, request), Results$.MODULE$.Redirect$default$2(), Results$.MODULE$.Redirect$default$3()));
        }
        if (string != null && !(option = resolveEvolutions.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String db = (String)((LinearSeqOps)option.get()).apply(0);
            String rev = (String)((LinearSeqOps)option.get()).apply(1);
            EvolutionsDatasourceConfig dbConfig = this.config.forDatasource(db);
            this.evolutions.resolve(db, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(rev)), dbConfig.schema(), dbConfig.metaTable());
            buildLink.forceReload();
            return new Some((Object)Results$.MODULE$.Redirect(EvolutionsWebCommands.redirectUrl$1(redirectUrl$lzy, request), Results$.MODULE$.Redirect$default$2(), Results$.MODULE$.Redirect$default$3()));
        }
        EvolutionsWebCommands evolutionsWebCommands = this;
        synchronized (evolutionsWebCommands) {
            if (!this.checkedAlready()) {
                this.dbApi.databases().foreach((Function1 & Serializable)x$9 -> {
                    ApplicationEvolutions$.MODULE$.runEvolutions(x$9, this.config, this.evolutions, this.reader, (Function4<String, EvolutionsDatasourceConfig, Seq<Script>, Object, BoxedUnit>)(Function4 & Serializable)(db, dbConfig, scripts, hasDown) -> EvolutionsWebCommands.$anonfun$handleWebCommand$5(db, dbConfig, scripts, BoxesRunTime.unboxToBoolean((Object)hasDown)));
                    return BoxedUnit.UNIT;
                });
                this.checkedAlready_$eq(true);
            }
        }
        return None$.MODULE$;
    }

    private static final /* synthetic */ String redirectUrl$lzycompute$1(LazyRef redirectUrl$lzy$1, RequestHeader request$1) {
        String string;
        LazyRef lazyRef = redirectUrl$lzy$1;
        synchronized (lazyRef) {
            string = redirectUrl$lzy$1.initialized() ? (String)redirectUrl$lzy$1.value() : (String)redirectUrl$lzy$1.initialize(request$1.queryString().get((Object)"redirect").filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isEmpty())).map((Function1 & Serializable)x$8 -> (String)x$8.head()).getOrElse((Function0 & Serializable)() -> "/"));
        }
        return string;
    }

    private static final String redirectUrl$1(LazyRef redirectUrl$lzy$1, RequestHeader request$1) {
        if (redirectUrl$lzy$1.initialized()) {
            return (String)redirectUrl$lzy$1.value();
        }
        return EvolutionsWebCommands.redirectUrl$lzycompute$1(redirectUrl$lzy$1, request$1);
    }

    public static final /* synthetic */ Nothing$ $anonfun$handleWebCommand$5(String db, EvolutionsDatasourceConfig dbConfig, Seq scripts, boolean hasDown) {
        throw new InvalidDatabaseRevision(db, Evolutions$.MODULE$.toHumanReadableScript((Seq<Script>)scripts));
    }

    @Inject
    public EvolutionsWebCommands(DBApi dbApi, EvolutionsApi evolutions, EvolutionsReader reader, EvolutionsConfig config) {
        this.dbApi = dbApi;
        this.evolutions = evolutions;
        this.reader = reader;
        this.config = config;
        this.checkedAlready = false;
    }
}

