/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import java.io.Serializable;
import javax.sql.DataSource;
import org.jdbcdslog.AccessConnectionPoolDataSourceProxy;
import org.jdbcdslog.ConnectionPoolDataSourceProxy;
import play.api.Environment;
import play.api.Mode;
import play.api.db.ConnectionPool;
import play.api.db.HikariCPConnectionPool;
import play.api.inject.Injector;
import play.utils.Reflect$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class ConnectionPool$ {
    public static final ConnectionPool$ MODULE$ = new ConnectionPool$();
    private static final Regex PostgresFullUrl = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^postgres://([a-zA-Z0-9_]+):([^@]+)@([^/]+)/([^\\s]+)$"));
    private static final Regex MysqlFullUrl = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^mysql://([a-zA-Z0-9_]+):([^@]+)@([^/]+)/([^\\s]+)$"));
    private static final Regex MysqlCustomProperties = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\?(.*)"));
    private static final Regex H2DefaultUrl = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^jdbc:h2:mem:.+"));

    public ConnectionPool fromConfig(String config, Injector injector, Environment environment, ConnectionPool connectionPool) {
        String string = config;
        switch (string == null ? 0 : string.hashCode()) {
            case -1576311941: {
                if (!"hikaricp".equals(string)) break;
                return new HikariCPConnectionPool(environment);
            }
            case 1544803905: {
                if (!"default".equals(string)) break;
                return connectionPool;
            }
        }
        return (ConnectionPool)injector.instanceOf(Reflect$.MODULE$.getClass(string, environment.classLoader(), ClassTag$.MODULE$.apply(ConnectionPool.class)));
    }

    public ConnectionPool fromConfig(String config, Environment environment, ConnectionPool connectionPool) {
        String string = config;
        switch (string == null ? 0 : string.hashCode()) {
            case -1576311941: {
                if (!"hikaricp".equals(string)) break;
                return new HikariCPConnectionPool(environment);
            }
        }
        return connectionPool;
    }

    private Regex PostgresFullUrl() {
        return PostgresFullUrl;
    }

    private Regex MysqlFullUrl() {
        return MysqlFullUrl;
    }

    private Regex MysqlCustomProperties() {
        return MysqlCustomProperties;
    }

    private Regex H2DefaultUrl() {
        return H2DefaultUrl;
    }

    public Tuple2<Option<String>, Option<Tuple2<String, String>>> extractUrl(Option<String> maybeUrl, Mode mode) {
        Option option;
        String url;
        Option option2;
        String url2;
        boolean bl = false;
        Some some = null;
        Option<String> option3 = maybeUrl;
        if (option3 instanceof Some) {
            Option option4;
            bl = true;
            some = (Some)option3;
            String string = (String)some.value();
            if (string != null && !(option4 = this.PostgresFullUrl().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(4) == 0) {
                String username = (String)((LinearSeqOps)option4.get()).apply(0);
                String password = (String)((LinearSeqOps)option4.get()).apply(1);
                String host = (String)((LinearSeqOps)option4.get()).apply(2);
                String dbname = (String)((LinearSeqOps)option4.get()).apply(3);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)("jdbc:postgresql://" + host + "/" + dbname))), (Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)username), (Object)password)));
            }
        }
        if (bl && (url2 = (String)some.value()) != null && !(option2 = this.MysqlFullUrl().unapplySeq((CharSequence)url2)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(4) == 0) {
            String username = (String)((LinearSeqOps)option2.get()).apply(0);
            String password = (String)((LinearSeqOps)option2.get()).apply(1);
            String host = (String)((LinearSeqOps)option2.get()).apply(2);
            String dbname = (String)((LinearSeqOps)option2.get()).apply(3);
            String defaultProperties = "?useUnicode=yes&characterEncoding=UTF-8&connectionCollation=utf8_general_ci";
            String addDefaultPropertiesIfNeeded = (String)this.MysqlCustomProperties().findFirstMatchIn((CharSequence)url2).map((Function1 & Serializable)x$1 -> "").getOrElse((Function0 & Serializable)() -> defaultProperties);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)("jdbc:mysql://" + host + "/" + dbname + addDefaultPropertiesIfNeeded))), (Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)username), (Object)password)));
        }
        if (bl && (url = (String)some.value()) != null && !(option = this.H2DefaultUrl().unapplySeq((CharSequence)url)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(0) == 0 && !url.contains("DB_CLOSE_DELAY")) {
            Mode mode2 = mode;
            Mode.Dev$ dev$ = Mode.Dev$.MODULE$;
            if (!(mode2 != null ? !mode2.equals(dev$) : dev$ != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)(url + ";DB_CLOSE_DELAY=-1"))), (Object)None$.MODULE$);
            }
        }
        if (bl) {
            String url3 = (String)some.value();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)url3)), (Object)None$.MODULE$);
        }
        if (None$.MODULE$.equals(option3)) {
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)None$.MODULE$);
        }
        throw new MatchError(option3);
    }

    public DataSource wrapToLogSql(DataSource dataSource, Config configuration) {
        if (configuration.getBoolean("logSql")) {
            ConnectionPoolDataSourceProxy proxyDataSource = new ConnectionPoolDataSourceProxy();
            proxyDataSource.setTargetDSDirect((Object)dataSource);
            return proxyDataSource;
        }
        return dataSource;
    }

    public DataSource unwrap(DataSource dataSource) {
        DataSource dataSource2 = dataSource;
        if (dataSource2 instanceof ConnectionPoolDataSourceProxy) {
            ConnectionPoolDataSourceProxy connectionPoolDataSourceProxy = (ConnectionPoolDataSourceProxy)dataSource2;
            return AccessConnectionPoolDataSourceProxy.getTargetDatasource(connectionPoolDataSourceProxy);
        }
        return dataSource;
    }

    private ConnectionPool$() {
    }
}

