/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import javax.sql.DataSource;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.db.Database;
import play.api.db.DatabaseConfig;
import play.api.db.DatabaseConfig$;
import play.api.db.TransactionIsolationLevel;
import play.utils.ProxyDriver;
import play.utils.Reflect$;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

public abstract class DefaultDatabase
implements Database {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DefaultDatabase.class.getDeclaredField("url$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DefaultDatabase.class.getDeclaredField("dataSource$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DefaultDatabase.class.getDeclaredField("driver$lzy1"));
    private final String name;
    private final Environment environment;
    private final Configuration config;
    private final DatabaseConfig databaseConfig;
    private volatile Object driver$lzy1;
    private volatile Object dataSource$lzy1;
    private volatile Object url$lzy1;

    public DefaultDatabase(String name, Config configuration, Environment environment) {
        this.name = name;
        this.environment = environment;
        this.config = Configuration$.MODULE$.apply(configuration);
        this.databaseConfig = DatabaseConfig$.MODULE$.fromConfig(this.config, environment);
    }

    public String name() {
        return this.name;
    }

    public DatabaseConfig databaseConfig() {
        return this.databaseConfig;
    }

    public abstract DataSource createDataSource();

    public abstract void closeDataSource(DataSource var1);

    public Option<Driver> driver() {
        Object object = this.driver$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.driver$lzyINIT1();
    }

    private Object driver$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.driver$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.databaseConfig().driver().map((Function1 & Serializable)driverClassName -> {
                            void v0;
                            try {
                                void var2_2;
                                ProxyDriver proxyDriver = new ProxyDriver((Driver)Reflect$.MODULE$.createInstance(driverClassName, this.environment.classLoader(), ClassTag$.MODULE$.apply(Driver.class)));
                                DriverManager.registerDriver((Driver)proxyDriver);
                                v0 = var2_2;
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable e = throwable3 = (Throwable)option.get();
                                    throw this.config.reportError("driver", "Driver not found: [" + driverClassName + "}]", (Option)Some$.MODULE$.apply((Object)e));
                                }
                                throw throwable;
                            }
                            return v0;
                        });
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.driver$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DataSource dataSource() {
        Object object = this.dataSource$lzy1;
        if (object instanceof DataSource) {
            return (DataSource)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DataSource)this.dataSource$lzyINIT1();
    }

    private Object dataSource$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dataSource$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DataSource dataSource = null;
                    try {
                        this.driver();
                        dataSource = this.createDataSource();
                        object2 = dataSource == null ? LazyVals.NullValue$.MODULE$ : dataSource;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dataSource$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return dataSource;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String url() {
        Object object = this.url$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.url$lzyINIT1();
    }

    private Object url$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.url$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = (String)this.databaseConfig().url().getOrElse(this::url$lzyINIT1$$anonfun$1);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.url$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Connection getConnection() {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean autocommit) {
        Connection connection = this.dataSource().getConnection();
        try {
            connection.setAutoCommit(autocommit);
        }
        catch (Throwable e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    public <A> A withConnection(Function1<Connection, A> block) {
        return this.withConnection(true, block);
    }

    public <A> A withConnection(boolean autocommit, Function1<Connection, A> block) {
        Object object;
        try (Connection connection = this.getConnection(autocommit);){
            object = block.apply((Object)connection);
        }
        return (A)object;
    }

    public <A> A withTransaction(Function1<Connection, A> block) {
        return this.withConnection(false, (Function1 & Serializable)connection -> {
            void v0;
            try {
                void var2_2;
                Object r = block.apply(connection);
                connection.commit();
                v0 = var2_2;
            }
            catch (ControlThrowable e) {
                connection.commit();
                throw e;
            }
            catch (Throwable e) {
                connection.rollback();
                throw e;
            }
            return v0;
        });
    }

    public <A> A withTransaction(TransactionIsolationLevel isolationLevel, Function1<Connection, A> block) {
        return this.withConnection(false, (Function1 & Serializable)connection -> {
            Object object;
            int oldIsolationLevel = connection.getTransactionIsolation();
            try {
                try {
                    connection.setTransactionIsolation(isolationLevel.id());
                    Object r = block.apply(connection);
                    connection.commit();
                    object = r;
                }
                catch (ControlThrowable e) {
                    connection.commit();
                    throw e;
                }
                catch (Throwable e) {
                    connection.rollback();
                    throw e;
                }
            }
            finally {
                connection.setTransactionIsolation(oldIsolationLevel);
            }
            return object;
        });
    }

    public void shutdown() {
        this.closeDataSource(this.dataSource());
        this.deregisterDriver();
    }

    public void deregisterDriver() {
        this.driver().foreach((Function1)(JProcedure1 & Serializable)x$0 -> DriverManager.deregisterDriver(x$0));
    }

    private final String url$lzyINIT1$$anonfun$1() {
        String string;
        try (Connection connection = this.dataSource().getConnection();){
            string = connection.getMetaData().getURL();
        }
        return string;
    }
}

