/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import java.io.Serializable;
import javax.sql.DataSource;
import org.jdbcdslog.AccessConnectionPoolDataSourceProxy;
import org.jdbcdslog.ConnectionPoolDataSourceProxy;
import play.api.Environment;
import play.api.Mode;
import play.api.db.ConnectionPool;
import play.api.db.HikariCPConnectionPool;
import play.api.inject.Injector;
import play.utils.Reflect$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class ConnectionPool$
implements Serializable {
    private static final Regex PostgresFullUrl;
    private static final Regex MysqlFullUrl;
    private static final Regex MysqlCustomProperties;
    private static final Regex H2DefaultUrl;
    public static final ConnectionPool$ MODULE$;

    private ConnectionPool$() {
    }

    static {
        MODULE$ = new ConnectionPool$();
        PostgresFullUrl = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^postgres://([a-zA-Z0-9_]+):([^@]+)@([^/]+)/([^\\s]+)$"));
        MysqlFullUrl = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^mysql://([a-zA-Z0-9_]+):([^@]+)@([^/]+)/([^\\s]+)$"));
        MysqlCustomProperties = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\?(.*)"));
        H2DefaultUrl = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^jdbc:h2:mem:.+"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ConnectionPool$.class);
    }

    public ConnectionPool fromConfig(String config, Injector injector, Environment environment, ConnectionPool connectionPool) {
        String string = config;
        if ("default".equals(string)) {
            return connectionPool;
        }
        if ("hikaricp".equals(string)) {
            return new HikariCPConnectionPool(environment);
        }
        String fqcn = string;
        return (ConnectionPool)injector.instanceOf(Reflect$.MODULE$.getClass(fqcn, environment.classLoader(), ClassTag$.MODULE$.apply(ConnectionPool.class)));
    }

    public ConnectionPool fromConfig(String config, Environment environment, ConnectionPool connectionPool) {
        String string = config;
        if ("hikaricp".equals(string)) {
            return new HikariCPConnectionPool(environment);
        }
        return connectionPool;
    }

    public Tuple2<Option<String>, Option<Tuple2<String, String>>> extractUrl(Option<String> maybeUrl, Mode mode) {
        Option<String> option = maybeUrl;
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            if (string != null) {
                String url;
                List list;
                List list2;
                List list3;
                Option option2 = PostgresFullUrl.unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && (list3 = (List)option2.get()).lengthCompare(4) == 0) {
                    String string2 = (String)list3.apply(0);
                    String string3 = (String)list3.apply(1);
                    String string4 = (String)list3.apply(2);
                    String string5 = (String)list3.apply(3);
                    String username = string2;
                    String password = string3;
                    String host = string4;
                    String dbname = string5;
                    Some some = (Some)Predef$.MODULE$.ArrowAssoc((Object)Some$.MODULE$.apply((Object)("jdbc:postgresql://" + host + "/" + dbname)));
                    String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)username);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)some, (Object)Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)password)));
                }
                Option option3 = MysqlFullUrl.unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && (list2 = (List)option3.get()).lengthCompare(4) == 0) {
                    String string7 = (String)list2.apply(0);
                    String string8 = (String)list2.apply(1);
                    String string9 = (String)list2.apply(2);
                    String string10 = (String)list2.apply(3);
                    String username = string7;
                    String password = string8;
                    String host = string9;
                    String dbname = string10;
                    String url2 = string;
                    String defaultProperties = "?useUnicode=yes&characterEncoding=UTF-8&connectionCollation=utf8_general_ci";
                    String addDefaultPropertiesIfNeeded = (String)MysqlCustomProperties.findFirstMatchIn((CharSequence)url2).map((Function1 & Serializable)_$1 -> "").getOrElse(() -> this.$anonfun$2(defaultProperties));
                    Some some = (Some)Predef$.MODULE$.ArrowAssoc((Object)Some$.MODULE$.apply((Object)("jdbc:mysql://" + host + "/" + (dbname + addDefaultPropertiesIfNeeded))));
                    String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)username);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)some, (Object)Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, (Object)password)));
                }
                Option option4 = H2DefaultUrl.unapplySeq((CharSequence)string);
                if (!option4.isEmpty() && (list = (List)option4.get()).lengthCompare(0) == 0 && !(url = string).contains("DB_CLOSE_DELAY")) {
                    Mode mode2 = mode;
                    Mode.Dev$ dev$ = Mode.Dev$.MODULE$;
                    if (!(mode2 != null ? !mode2.equals(dev$) : dev$ != null)) {
                        Some some = (Some)Predef$.MODULE$.ArrowAssoc((Object)Some$.MODULE$.apply((Object)(url + ";DB_CLOSE_DELAY=-1")));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)some, (Object)None$.MODULE$);
                    }
                }
            }
            String url = string;
            Some some = (Some)Predef$.MODULE$.ArrowAssoc((Object)Some$.MODULE$.apply((Object)url));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)some, (Object)None$.MODULE$);
        }
        if (None$.MODULE$.equals(option)) {
            None$ none$ = (None$)Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)none$, (Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public DataSource wrapToLogSql(DataSource dataSource, Config configuration) {
        if (configuration.getBoolean("logSql")) {
            ConnectionPoolDataSourceProxy proxyDataSource = new ConnectionPoolDataSourceProxy();
            proxyDataSource.setTargetDSDirect((Object)dataSource);
            return proxyDataSource;
        }
        return dataSource;
    }

    public DataSource unwrap(DataSource dataSource) {
        DataSource dataSource2 = dataSource;
        if (dataSource2 instanceof ConnectionPoolDataSourceProxy) {
            ConnectionPoolDataSourceProxy ds = (ConnectionPoolDataSourceProxy)dataSource2;
            return AccessConnectionPoolDataSourceProxy.getTargetDatasource(ds);
        }
        return dataSource;
    }

    private final String $anonfun$2(String defaultProperties$1) {
        return defaultProperties$1;
    }
}

