/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.zaxxer.hikari.HikariConfig;
import java.io.Serializable;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.db.DatabaseConfig;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class HikariCPConfig {
    private final Option<String> maybeName;
    private final DatabaseConfig dbConfig;
    private final Configuration configuration;

    private HikariCPConfig(Option<String> maybeName, DatabaseConfig dbConfig, Configuration configuration) {
        this.maybeName = maybeName;
        this.dbConfig = dbConfig;
        this.configuration = configuration;
    }

    public HikariCPConfig(String name, DatabaseConfig dbConfig, Configuration configuration) {
        this((Option<String>)Some$.MODULE$.apply((Object)name), dbConfig, configuration);
    }

    public HikariCPConfig(DatabaseConfig dbConfig, Configuration configuration) {
        this((Option<String>)None$.MODULE$, dbConfig, configuration);
    }

    public HikariConfig toHikariConfig() {
        HikariConfig hikariConfig = new HikariConfig();
        Configuration config = (Configuration)this.configuration.get("hikaricp", ConfigLoader$.MODULE$.configurationLoader());
        ((Option)config.get("dataSourceClassName", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setDataSourceClassName(x$0));
        this.dbConfig.url().foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setJdbcUrl(x$0));
        this.dbConfig.driver().foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setDriverClassName(x$0));
        this.dbConfig.username().foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setUsername(x$0));
        this.dbConfig.password().foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setPassword(x$0));
        Configuration dataSourceConfig = (Configuration)config.get("dataSource", ConfigLoader$.MODULE$.configurationLoader());
        CollectionConverters$.MODULE$.SetHasAsScala(dataSourceConfig.underlying().root().keySet()).asScala().foreach((Function1)(JProcedure1 & Serializable)key -> hikariConfig.addDataSourceProperty(key, dataSourceConfig.get(key, ConfigLoader$.MODULE$.stringLoader())));
        hikariConfig.setAutoCommit(BoxesRunTime.unboxToBoolean((Object)config.get("autoCommit", ConfigLoader$.MODULE$.booleanLoader())));
        hikariConfig.setConnectionTimeout(HikariCPConfig.toMillis$1((Duration)config.get("connectionTimeout", ConfigLoader$.MODULE$.durationLoader())));
        hikariConfig.setIdleTimeout(HikariCPConfig.toMillis$1((Duration)config.get("idleTimeout", ConfigLoader$.MODULE$.durationLoader())));
        ((Option)config.get("keepaliveTime", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.durationLoader()))).foreach((Function1)(JProcedure1 & Serializable)duration -> hikariConfig.setKeepaliveTime(HikariCPConfig.toMillis$1(duration)));
        hikariConfig.setMaxLifetime(HikariCPConfig.toMillis$1((Duration)config.get("maxLifetime", ConfigLoader$.MODULE$.durationLoader())));
        ((Option)config.get("connectionTestQuery", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setConnectionTestQuery(x$0));
        ((Option)config.get("minimumIdle", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.intLoader()))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$0 -> hikariConfig.setMinimumIdle(x$0));
        hikariConfig.setMaximumPoolSize(BoxesRunTime.unboxToInt((Object)config.get("maximumPoolSize", ConfigLoader$.MODULE$.intLoader())));
        ((Option)config.get("poolName", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).orElse(this::toHikariConfig$$anonfun$10).foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setPoolName(x$0));
        hikariConfig.setInitializationFailTimeout(BoxesRunTime.unboxToLong((Object)config.get("initializationFailTimeout", ConfigLoader$.MODULE$.longLoader())));
        hikariConfig.setIsolateInternalQueries(BoxesRunTime.unboxToBoolean((Object)config.get("isolateInternalQueries", ConfigLoader$.MODULE$.booleanLoader())));
        hikariConfig.setAllowPoolSuspension(BoxesRunTime.unboxToBoolean((Object)config.get("allowPoolSuspension", ConfigLoader$.MODULE$.booleanLoader())));
        hikariConfig.setReadOnly(BoxesRunTime.unboxToBoolean((Object)config.get("readOnly", ConfigLoader$.MODULE$.booleanLoader())));
        hikariConfig.setRegisterMbeans(BoxesRunTime.unboxToBoolean((Object)config.get("registerMbeans", ConfigLoader$.MODULE$.booleanLoader())));
        ((Option)config.get("connectionInitSql", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setConnectionInitSql(x$0));
        ((Option)config.get("catalog", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setCatalog(x$0));
        ((Option)config.get("transactionIsolation", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setTransactionIsolation(x$0));
        ((Option)config.get("exceptionOverrideClassName", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1)(JProcedure1 & Serializable)x$0 -> hikariConfig.setExceptionOverrideClassName(x$0));
        hikariConfig.setValidationTimeout(((FiniteDuration)config.get("validationTimeout", ConfigLoader$.MODULE$.finiteDurationLoader())).toMillis());
        hikariConfig.setLeakDetectionThreshold(HikariCPConfig.toMillis$1((Duration)config.get("leakDetectionThreshold", ConfigLoader$.MODULE$.durationLoader())));
        hikariConfig.validate();
        return hikariConfig;
    }

    private static final long toMillis$1(Duration duration) {
        if (duration.isFinite()) {
            return duration.toMillis();
        }
        return 0L;
    }

    private final Option toHikariConfig$$anonfun$10() {
        return this.maybeName.map((Function1 & Serializable)name -> "HikariPool-" + name);
    }
}

