/*
 * Decompiled with CFR 0.152.
 */
package play.runsupport;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import play.api.PlayException;
import play.runsupport.Source;

public interface CompileResult {

    public static class CompileFailure
    implements CompileResult {
        private final PlayException exception;

        public CompileFailure(PlayException playException) {
            this.exception = Objects.requireNonNull(playException);
        }

        public PlayException getException() {
            return this.exception;
        }
    }

    public static class CompileSuccess
    implements CompileResult {
        private final Map<String, Source> sources;
        private final List<File> classpath;

        public CompileSuccess(Map<String, Source> map, List<File> list) {
            this.sources = Objects.requireNonNullElse(map, Map.of());
            this.classpath = Objects.requireNonNullElse(list, List.of());
        }

        public Map<String, Source> getSources() {
            return this.sources;
        }

        public List<File> getClasspath() {
            return this.classpath;
        }
    }
}

